/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.interfaces;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorFactory;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.agents.transformationconnection.TransformationConnectionManager;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class TransformationConnectionManagerFactory {
    public static final String _rcsid = "@(#)$Id$";
    private static final String objectName = "_TransformationConnectionMgr_";

    private TransformationConnectionManagerFactory() {
    }

    public static ITransformationConnectionManager make(IThreadContext tc) throws ManifoldCFException {
        Object o = tc.get((Object)objectName);
        if (o == null || !(o instanceof ITransformationConnectionManager)) {
            IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            o = new TransformationConnectionManager(tc, database);
            tc.save((Object)objectName, o);
        }
        return (ITransformationConnectionManager)o;
    }

    public static String[] getAllTransformationActivities(IThreadContext tc) throws ManifoldCFException {
        ITransformationConnectionManager manager = TransformationConnectionManagerFactory.make(tc);
        ITransformationConnection[] connections = manager.getAllConnections();
        HashSet<String> map = new HashSet<String>();
        for (ITransformationConnection connection : connections) {
            String connectionName = connection.getName();
            String[] activities = TransformationConnectorFactory.getActivitiesList(tc, connection.getClassName());
            if (activities == null) continue;
            for (String baseActivity : activities) {
                String activity = ManifoldCF.qualifyTransformationActivityName(baseActivity, connectionName);
                map.add(activity);
            }
        }
        Object[] rval = new String[map.size()];
        int i = 0;
        Iterator iter = map.iterator();
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        Arrays.sort(rval);
        return rval;
    }
}

