/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.interfaces;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class RepositoryDocument {
    public static final String _rcsid = "@(#)$Id: RepositoryDocument.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String SECURITY_TYPE_DOCUMENT = "document";
    public static final String SECURITY_TYPE_SHARE = "share";
    public static final String SECURITY_TYPE_PARENT = "parent";
    public static final String SECURITY_TYPE_DIRECTORY_LEVEL = "directory_";
    protected InputStream binaryFieldData = null;
    protected long binaryLength = 0L;
    protected final Set<String> fieldSet = new HashSet<String>();
    protected final Map<String, Object> fields = new HashMap<String, Object>();
    protected final Map<String, String[]> stringFields = new HashMap<String, String[]>();
    protected final Map<String, Reader[]> readerFields = new HashMap<String, Reader[]>();
    protected final Map<String, Date[]> dateFields = new HashMap<String, Date[]>();
    protected final Map<String, Security> securityLevels = new HashMap<String, Security>();
    protected final List<String> sourcePath = new ArrayList<String>();
    protected final List<String> rootPath = new ArrayList<String>();
    protected String fileName = "docname";
    protected String contentMimeType = "application/octet-stream";
    protected Date createdDate = null;
    protected Date modifiedDate = null;
    protected Date indexingDate = null;
    protected Long originalSize = null;

    public RepositoryDocument duplicate() {
        RepositoryDocument rval = new RepositoryDocument();
        rval.binaryFieldData = this.binaryFieldData;
        rval.binaryLength = this.binaryLength;
        rval.fileName = this.fileName;
        rval.contentMimeType = this.contentMimeType;
        rval.createdDate = this.createdDate;
        rval.modifiedDate = this.modifiedDate;
        rval.indexingDate = this.indexingDate;
        rval.originalSize = this.originalSize;
        for (String key : this.fieldSet) {
            rval.fieldSet.add(key);
        }
        for (String key : this.fields.keySet()) {
            rval.fields.put(key, this.fields.get(key));
        }
        for (String key : this.stringFields.keySet()) {
            rval.stringFields.put(key, this.stringFields.get(key));
        }
        for (String key : this.readerFields.keySet()) {
            rval.readerFields.put(key, this.readerFields.get(key));
        }
        for (String key : this.dateFields.keySet()) {
            rval.dateFields.put(key, this.dateFields.get(key));
        }
        for (String key : this.securityLevels.keySet()) {
            rval.securityLevels.put(key, this.securityLevels.get(key));
        }
        for (String pathElement : this.sourcePath) {
            rval.sourcePath.add(pathElement);
        }
        for (String pathElement : this.rootPath) {
            rval.rootPath.add(pathElement);
        }
        return rval;
    }

    public void clearFields() {
        this.fieldSet.clear();
        this.fields.clear();
        this.stringFields.clear();
        this.dateFields.clear();
        this.readerFields.clear();
    }

    public void setSourcePath(List<String> sourcePath) {
        this.sourcePath.clear();
        for (String pathElement : sourcePath) {
            this.sourcePath.add(pathElement);
        }
    }

    public List<String> getSourcePath() {
        return this.sourcePath;
    }

    public void setRootPath(List<String> rootPath) {
        this.rootPath.clear();
        for (String pathElement : rootPath) {
            this.rootPath.add(pathElement);
        }
    }

    public List<String> getRootPath() {
        return this.rootPath;
    }

    public void setOriginalSize(Long size) {
        this.originalSize = size;
    }

    public Long getOriginalSize() {
        return this.originalSize;
    }

    public void setCreatedDate(Date date) {
        this.createdDate = date;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setModifiedDate(Date date) {
        this.modifiedDate = date;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setIndexingDate(Date date) {
        this.indexingDate = date;
    }

    public Date getIndexingDate() {
        return this.indexingDate;
    }

    public void setMimeType(String mimeType) {
        this.contentMimeType = mimeType;
    }

    public String getMimeType() {
        return this.contentMimeType;
    }

    protected Security getSecurityLevel(String securityType) {
        Security s = this.securityLevels.get(securityType);
        if (s == null) {
            s = new Security();
            this.securityLevels.put(securityType, s);
        }
        return s;
    }

    public Iterator<String> securityTypesIterator() {
        return this.securityLevels.keySet().iterator();
    }

    public void setSecurity(String securityType, String[] acl, String[] denyAcl) {
        if (acl != null && denyAcl != null) {
            Security s = this.getSecurityLevel(securityType);
            s.setACL(acl);
            s.setDenyACL(denyAcl);
        }
    }

    public void setSecurityACL(String securityType, String[] acl) {
        if (acl != null) {
            Security s = this.getSecurityLevel(securityType);
            s.setACL(acl);
        }
    }

    public void setSecurityDenyACL(String securityType, String[] denyAcl) {
        if (denyAcl != null) {
            Security s = this.getSecurityLevel(securityType);
            s.setDenyACL(denyAcl);
        }
    }

    public String[] getSecurityACL(String securityType) {
        Security s = this.securityLevels.get(securityType);
        if (s != null) {
            return s.getACL();
        }
        return null;
    }

    public String[] getSecurityDenyACL(String securityType) {
        Security s = this.securityLevels.get(securityType);
        if (s != null) {
            return s.getDenyACL();
        }
        return null;
    }

    public void setBinary(InputStream binaryFieldData, long binaryLength) {
        this.binaryFieldData = binaryFieldData;
        this.binaryLength = binaryLength;
    }

    public InputStream getBinaryStream() {
        return this.binaryFieldData;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getBinaryLength() {
        return this.binaryLength;
    }

    public void removeField(String fieldName) {
        this.fieldSet.remove(fieldName);
        this.fields.remove(fieldName);
        this.stringFields.remove(fieldName);
        this.readerFields.remove(fieldName);
        this.dateFields.remove(fieldName);
    }

    public void addField(String fieldName, Date[] fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.fieldSet.remove(fieldName);
            this.fields.remove(fieldName);
            this.stringFields.remove(fieldName);
            this.readerFields.remove(fieldName);
            this.dateFields.remove(fieldName);
        } else {
            this.fieldSet.add(fieldName);
            this.fields.put(fieldName, fieldData);
            this.stringFields.remove(fieldName);
            this.readerFields.remove(fieldName);
            this.dateFields.put(fieldName, fieldData);
        }
    }

    public void addField(String fieldName, Date fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.addField(fieldName, (Date[])null);
        } else {
            this.addField(fieldName, new Date[]{fieldData});
        }
    }

    public void addField(String fieldName, Reader[] fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.fieldSet.remove(fieldName);
            this.fields.remove(fieldName);
            this.stringFields.remove(fieldName);
            this.readerFields.remove(fieldName);
            this.dateFields.remove(fieldName);
        } else {
            this.fieldSet.add(fieldName);
            this.fields.put(fieldName, fieldData);
            this.stringFields.remove(fieldName);
            this.readerFields.put(fieldName, fieldData);
            this.dateFields.remove(fieldName);
        }
    }

    public void addField(String fieldName, Reader fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.addField(fieldName, (Reader[])null);
        } else {
            this.addField(fieldName, new Reader[]{fieldData});
        }
    }

    public void addField(String fieldName, String[] fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.fieldSet.remove(fieldName);
            this.fields.remove(fieldName);
            this.stringFields.remove(fieldName);
            this.readerFields.remove(fieldName);
            this.dateFields.remove(fieldName);
        } else {
            this.fieldSet.add(fieldName);
            this.fields.put(fieldName, fieldData);
            this.readerFields.remove(fieldName);
            this.stringFields.put(fieldName, fieldData);
            this.dateFields.remove(fieldName);
        }
    }

    public void addField(String fieldName, String fieldData) throws ManifoldCFException {
        if (fieldData == null) {
            this.addField(fieldName, (String[])null);
        } else {
            this.addField(fieldName, new String[]{fieldData});
        }
    }

    public Object[] getField(String fieldName) {
        return (Object[])this.fields.get(fieldName);
    }

    public String[] getFieldAsStrings(String fieldName) throws IOException {
        String[] stringFieldData = this.stringFields.get(fieldName);
        if (stringFieldData != null) {
            return stringFieldData;
        }
        Date[] dateFieldData = this.dateFields.get(fieldName);
        if (dateFieldData != null) {
            String[] newValues = new String[dateFieldData.length];
            for (int i = 0; i < dateFieldData.length; ++i) {
                newValues[i] = DateParser.formatISO8601Date((Date)dateFieldData[i]);
            }
            return newValues;
        }
        Reader[] oldValues = this.readerFields.get(fieldName);
        if (oldValues != null) {
            String[] newValues = new String[oldValues.length];
            char[] buffer = new char[65536];
            for (int i = 0; i < newValues.length; ++i) {
                int amt;
                Reader oldValue = oldValues[i];
                StringBuilder newValue = new StringBuilder();
                while ((amt = oldValue.read(buffer)) != -1) {
                    newValue.append(buffer, 0, amt);
                }
                newValues[i] = newValue.toString();
            }
            this.stringFields.put(fieldName, newValues);
            this.readerFields.remove(fieldName);
            this.fields.put(fieldName, newValues);
            return newValues;
        }
        return null;
    }

    public Reader[] getFieldAsReaders(String fieldName) {
        Reader[] readerFieldData = this.readerFields.get(fieldName);
        if (readerFieldData != null) {
            return readerFieldData;
        }
        Date[] dateFieldData = this.dateFields.get(fieldName);
        if (dateFieldData != null) {
            Reader[] newValues = new Reader[dateFieldData.length];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = new StringReader(DateParser.formatISO8601Date((Date)dateFieldData[i]));
            }
            this.readerFields.put(fieldName, newValues);
            return newValues;
        }
        String[] oldValues = this.stringFields.get(fieldName);
        if (oldValues != null) {
            Reader[] newValues = new Reader[oldValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = new StringReader(oldValues[i]);
            }
            this.readerFields.put(fieldName, newValues);
            return newValues;
        }
        return null;
    }

    public Date[] getFieldAsDates(String fieldName) {
        return this.dateFields.get(fieldName);
    }

    public int fieldCount() {
        return this.fieldSet.size();
    }

    public Iterator<String> getFields() {
        return this.fieldSet.iterator();
    }

    protected static class Security {
        protected String[] tokens = null;
        protected String[] denyTokens = null;

        public void setACL(String[] tokens) {
            this.tokens = tokens;
        }

        public String[] getACL() {
            return this.tokens;
        }

        public void setDenyACL(String[] tokens) {
            this.denyTokens = tokens;
        }

        public String[] getDenyACL() {
            return this.denyTokens;
        }
    }
}

