/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeStatement
extends SAMLSubjectStatement
implements Cloneable {
    protected ArrayList attrs = new ArrayList();

    public SAMLAttributeStatement() {
    }

    public SAMLAttributeStatement(SAMLSubject sAMLSubject, Collection collection) throws SAMLException {
        super(sAMLSubject);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.attrs.add(((SAMLAttribute)iterator.next()).setParent(this));
        }
    }

    public SAMLAttributeStatement(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAttributeStatement(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAttributeStatement.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement")) {
            object = XML.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement") && object != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(((QName)object).getNamespaceURI()) && "AttributeStatementType".equals(((QName)object).getLocalPart()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeStatement() requires saml:AttributeStatement at root");
            }
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        while (object != null) {
            try {
                this.attrs.add(SAMLAttribute.getInstance((Element)object).setParent(this));
            }
            catch (SAMLException sAMLException) {
                this.log.warn((Object)("exception while instantiating a SAMLAttribute: " + sAMLException.getMessage()));
            }
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        }
    }

    public Iterator getAttributes() {
        return this.attrs.iterator();
    }

    public void setAttributes(Collection collection) throws SAMLException {
        this.attrs.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.attrs.add(((SAMLAttribute)iterator.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addAttribute(SAMLAttribute sAMLAttribute) throws SAMLException {
        if (sAMLAttribute == null) {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        this.attrs.add(sAMLAttribute.setParent(this));
        this.setDirty(true);
    }

    public void removeAttribute(int n) {
        this.attrs.remove(n);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            Iterator iterator = this.attrs.iterator();
            while (iterator.hasNext()) {
                element.appendChild(((SAMLAttribute)iterator.next()).toDOM(document, false));
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        super.checkValidity();
        if (this.attrs == null || this.attrs.size() == 0) {
            throw new MalformedException("AttributeStatement is invalid, requires at least one attribute");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeStatement sAMLAttributeStatement = (SAMLAttributeStatement)super.clone();
        try {
            sAMLAttributeStatement.attrs = new ArrayList();
            Iterator iterator = this.attrs.iterator();
            while (iterator.hasNext()) {
                sAMLAttributeStatement.attrs.add(((SAMLAttribute)((SAMLAttribute)iterator.next()).clone()).setParent(sAMLAttributeStatement));
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLAttributeStatement;
    }
}

