/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IPipelineConnections;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecification;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;

public class PipelineSpecification
implements IPipelineSpecification {
    protected final IPipelineConnections connections;
    protected final VersionContext[] pipelineDescriptionStrings;

    public PipelineSpecification(IPipelineConnections connections, IJobDescription job, IIncrementalIngester ingester) throws ManifoldCFException, ServiceInterruption {
        this.connections = connections;
        this.pipelineDescriptionStrings = new VersionContext[connections.getStageCount()];
        for (int i = 0; i < this.pipelineDescriptionStrings.length; ++i) {
            VersionContext descriptionString = connections.checkStageOutputConnection(i) ? ingester.getOutputDescription(connections.getOutputConnections()[connections.getOutputConnectionIndex(i)], job.getPipelineStageSpecification(i)) : ingester.getTransformationDescription(connections.getTransformationConnections()[connections.getTransformationConnectionIndex(i)], job.getPipelineStageSpecification(i));
            this.pipelineDescriptionStrings[i] = descriptionString;
        }
    }

    public int getStageCount() {
        return this.connections.getStageCount();
    }

    public int[] getStageChildren(int stage) {
        return this.connections.getStageChildren(stage);
    }

    public int getStageParent(int stage) {
        return this.connections.getStageParent(stage);
    }

    public String getStageConnectionName(int stage) {
        return this.connections.getStageConnectionName(stage);
    }

    public boolean checkStageOutputConnection(int stage) {
        return this.connections.checkStageOutputConnection(stage);
    }

    public int getOutputCount() {
        return this.connections.getOutputCount();
    }

    public int getOutputStage(int index) {
        return this.connections.getOutputStage(index);
    }

    public String[] getTransformationConnectionNames() {
        return this.connections.getTransformationConnectionNames();
    }

    public ITransformationConnection[] getTransformationConnections() {
        return this.connections.getTransformationConnections();
    }

    public String[] getOutputConnectionNames() {
        return this.connections.getOutputConnectionNames();
    }

    public IOutputConnection[] getOutputConnections() {
        return this.connections.getOutputConnections();
    }

    public Integer getTransformationConnectionIndex(int stage) {
        return this.connections.getTransformationConnectionIndex(stage);
    }

    public Integer getOutputConnectionIndex(int stage) {
        return this.connections.getOutputConnectionIndex(stage);
    }

    public VersionContext getStageDescriptionString(int stage) {
        return this.pipelineDescriptionStrings[stage];
    }
}

