/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;
import org.castor.util.Configuration;

public final class TransactionManagerFactoryRegistry {
    private static final Log LOG = LogFactory.getLog((Class)TransactionManagerFactoryRegistry.class);
    private Map _factories = new HashMap();

    public TransactionManagerFactoryRegistry(Configuration config) {
        String prop = config.getProperty("org.castor.transactionmanager.Factories", "");
        StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
        ClassLoader loader = TransactionManagerFactoryRegistry.class.getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken();
            try {
                Class<?> cls = loader.loadClass(classname);
                Object obj = cls.newInstance();
                TransactionManagerFactory factory = (TransactionManagerFactory)obj;
                this._factories.put(factory.getName(), factory);
            }
            catch (Exception except) {
                LOG.error((Object)("The TransactionManagerFactory " + classname + " " + "specified in the Castor properties file could not " + "be instantiated."));
            }
        }
    }

    public String[] getTransactionManagerFactoryNames() {
        String[] names = new String[this._factories.size()];
        return this._factories.keySet().toArray(names);
    }

    public TransactionManagerFactory getTransactionManagerFactory(String name) throws TransactionManagerAcquireException {
        Object factory = this._factories.get(name);
        if (factory == null) {
            String msg = "The TransactionManagerFactory '" + name + "' " + "does not exist in the Castor properties file " + "and is therefore not supported.";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return (TransactionManagerFactory)factory;
    }
}

