/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.interfaces;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class TempFileCharacterInput
extends CharacterInput {
    public static final String _rcsid = "@(#)$Id: TempFileCharacterInput.java 988245 2010-08-23 18:39:35Z kwright $";
    protected File file;
    protected byte[] inMemoryBuffer;
    protected static final int CHUNK_SIZE = 65536;
    protected static final int DEFAULT_MAX_MEM_SIZE = 8192;

    public TempFileCharacterInput(Reader is) throws ManifoldCFException, IOException {
        this(is, -1L);
    }

    public TempFileCharacterInput(Reader is, long length) throws ManifoldCFException, IOException {
        this(is, length, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFileCharacterInput(Reader is, long length, int maxInMemoryLength) throws ManifoldCFException, IOException {
        int chunkSize = 65536;
        char[] buffer = new char[chunkSize];
        int chunkTotal = 0;
        boolean eofSeen = false;
        while (true) {
            int chunkAmount;
            if (length == -1L || length > (long)chunkSize) {
                chunkAmount = chunkSize - chunkTotal;
            } else {
                chunkAmount = (int)(length - (long)chunkTotal);
                eofSeen = true;
            }
            if (chunkAmount == 0) break;
            int readsize = is.read(buffer, chunkTotal, chunkAmount);
            if (readsize == -1) {
                eofSeen = true;
                break;
            }
            chunkTotal += readsize;
        }
        MessageDigest md = ManifoldCF.startHash();
        String chunkString = new String(buffer, 0, chunkTotal);
        ManifoldCF.addToHash(md, chunkString);
        byte[] byteBuffer = eofSeen ? chunkString.getBytes(StandardCharsets.UTF_8) : null;
        if (eofSeen && byteBuffer.length <= maxInMemoryLength) {
            this.file = null;
            this.inMemoryBuffer = byteBuffer;
            this.charLength = chunkTotal;
            this.hashValue = ManifoldCF.getHashValue(md);
        } else {
            File outfile;
            this.inMemoryBuffer = null;
            long totalMoved = 0L;
            try {
                outfile = File.createTempFile("_MC_", "");
            }
            catch (IOException e) {
                TempFileCharacterInput.handleIOException(e, "creating backing file");
                outfile = null;
            }
            try {
                OutputStreamWriter outWriter;
                FileOutputStream outStream;
                ManifoldCF.addFile(outfile);
                try {
                    outStream = new FileOutputStream(outfile);
                    outWriter = new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    TempFileCharacterInput.handleIOException(e, "opening backing file");
                    outStream = null;
                    outWriter = null;
                }
                try {
                    int moveAmount;
                    try {
                        outWriter.write(buffer, 0, chunkTotal);
                    }
                    catch (IOException e) {
                        TempFileCharacterInput.handleIOException(e, "writing backing file");
                    }
                    totalMoved += (long)chunkTotal;
                    while ((moveAmount = length == -1L || length - totalMoved > (long)chunkSize ? chunkSize : (int)(length - totalMoved)) != 0) {
                        int readsize = is.read(buffer, 0, moveAmount);
                        if (readsize == -1) {
                            break;
                        }
                        try {
                            outWriter.write(buffer, 0, readsize);
                        }
                        catch (IOException e) {
                            TempFileCharacterInput.handleIOException(e, "writing backing file");
                        }
                        ManifoldCF.addToHash(md, new String(buffer, 0, readsize));
                        totalMoved += (long)readsize;
                    }
                }
                finally {
                    try {
                        outWriter.close();
                    }
                    catch (IOException e) {
                        TempFileCharacterInput.handleIOException(e, "closing backing file");
                    }
                }
                this.file = outfile;
                this.charLength = totalMoved;
                this.hashValue = ManifoldCF.getHashValue(md);
            }
            catch (Throwable e) {
                ManifoldCF.deleteFile(outfile);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof ManifoldCFException) {
                    throw (ManifoldCFException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException("Unexpected throwable of type " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
    }

    public TempFileCharacterInput(File tempFile) {
        this.inMemoryBuffer = null;
        this.file = tempFile;
        ManifoldCF.addFile(this.file);
    }

    protected TempFileCharacterInput() {
    }

    @Override
    public InputStream getUtf8Stream() throws ManifoldCFException {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ManifoldCFException("No such file: " + e.getMessage(), e, 0);
            }
        }
        if (this.inMemoryBuffer != null) {
            return new ByteArrayInputStream(this.inMemoryBuffer);
        }
        return null;
    }

    @Override
    public long getUtf8StreamLength() throws ManifoldCFException {
        if (this.file != null) {
            return this.file.length();
        }
        if (this.inMemoryBuffer != null) {
            return this.inMemoryBuffer.length;
        }
        return 0L;
    }

    @Override
    protected void openStream() throws ManifoldCFException {
        if (this.file != null) {
            try {
                FileInputStream binaryStream = new FileInputStream(this.file);
                this.stream = new InputStreamReader((InputStream)binaryStream, StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new ManifoldCFException("Can't create stream: " + e.getMessage(), e, 0);
            }
        } else if (this.inMemoryBuffer != null) {
            this.stream = new InputStreamReader((InputStream)new ByteArrayInputStream(this.inMemoryBuffer), StandardCharsets.UTF_8);
        }
    }

    @Override
    public CharacterInput transfer() {
        TempFileCharacterInput rval = new TempFileCharacterInput();
        rval.file = this.file;
        rval.inMemoryBuffer = this.inMemoryBuffer;
        rval.stream = this.stream;
        rval.charLength = this.charLength;
        rval.hashValue = this.hashValue;
        this.file = null;
        this.inMemoryBuffer = null;
        this.stream = null;
        this.charLength = -1L;
        this.hashValue = null;
        return rval;
    }

    @Override
    public void discard() throws ManifoldCFException {
        super.discard();
        if (this.file != null) {
            ManifoldCF.deleteFile(this.file);
            this.file = null;
        }
    }

    @Override
    protected void calculateLength() throws ManifoldCFException {
        this.scanFile();
    }

    @Override
    protected void calculateHashValue() throws ManifoldCFException {
        this.scanFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile() throws ManifoldCFException {
        try {
            InputStream binaryStream = this.file != null ? new FileInputStream(this.file) : (this.inMemoryBuffer != null ? new ByteArrayInputStream(this.inMemoryBuffer) : null);
            try (InputStreamReader reader = new InputStreamReader(binaryStream, StandardCharsets.UTF_8);){
                int moveAmount;
                int readsize;
                MessageDigest md = ManifoldCF.startHash();
                char[] buffer = new char[65536];
                long totalMoved = 0L;
                while ((readsize = ((Reader)reader).read(buffer, 0, moveAmount = 65536)) != -1) {
                    ManifoldCF.addToHash(md, new String(buffer, 0, readsize));
                    totalMoved += (long)readsize;
                }
                this.charLength = totalMoved;
                this.hashValue = ManifoldCF.getHashValue(md);
            }
        }
        catch (IOException e) {
            TempFileCharacterInput.handleIOException(e, "scanning file");
        }
    }
}

