/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import java.util.ArrayList;
import java.util.List;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableInt;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableArray
extends VariableBase {
    protected List<Variable> array = new ArrayList<Variable>();

    public int hashCode() {
        int rval = 0;
        int i = 0;
        while (i < this.array.size()) {
            Variable v = this.array.get(i++);
            rval += v.hashCode();
        }
        return rval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableArray)) {
            return false;
        }
        VariableArray va = (VariableArray)o;
        if (va.array.size() != this.array.size()) {
            return false;
        }
        for (int i = 0; i < this.array.size(); ++i) {
            Variable v2;
            Variable v = this.array.get(i);
            if (v.equals(v2 = va.array.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        StringBuilder sb = new StringBuilder("[ ");
        int i = 0;
        while (i < this.array.size()) {
            Variable v;
            if (i > 0) {
                sb.append(", ");
            }
            if ((v = this.array.get(i++)) == null) {
                sb.append("null");
                continue;
            }
            sb.append(v.getScriptValue());
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public VariableReference getAttribute(String attributeName) throws ScriptException {
        if (attributeName.equals("__size__")) {
            return new VariableInt(this.array.size());
        }
        return super.getAttribute(attributeName);
    }

    @Override
    public VariableReference getIndexed(Variable index) throws ScriptException {
        if (index == null) {
            throw new ScriptException(this.composeMessage("Subscript cannot be null"));
        }
        int indexValue = index.getIntValue();
        if (indexValue >= 0 && indexValue < this.array.size()) {
            return new ElementReference(indexValue);
        }
        throw new ScriptException(this.composeMessage("Index out of bounds: " + indexValue));
    }

    @Override
    public void insertAt(Variable v, Variable index) throws ScriptException {
        if (index == null) {
            this.array.add(v);
        } else {
            int indexValue = index.getIntValue();
            if (indexValue < 0 || indexValue > this.array.size()) {
                throw new ScriptException(this.composeMessage("Insert index out of bounds: " + indexValue));
            }
            this.array.add(indexValue, v);
        }
    }

    @Override
    public void removeAt(Variable index) throws ScriptException {
        if (index == null) {
            throw new ScriptException(this.composeMessage("Array remove index cannot be null"));
        }
        int indexValue = index.getIntValue();
        if (indexValue < 0 || indexValue >= this.array.size()) {
            throw new ScriptException(this.composeMessage("Array remove index out of bounds: " + indexValue));
        }
        this.array.remove(indexValue);
    }

    protected class ElementReference
    implements VariableReference {
        protected int index;

        public ElementReference(int index) {
            this.index = index;
        }

        @Override
        public void setReference(Variable v) throws ScriptException {
            if (this.index < 0 || this.index >= VariableArray.this.array.size()) {
                throw new ScriptException(VariableArray.this.composeMessage("Index out of range for array children: " + this.index));
            }
            VariableArray.this.array.set(this.index, v);
        }

        @Override
        public Variable resolve() throws ScriptException {
            if (this.index < 0 || this.index >= VariableArray.this.array.size()) {
                throw new ScriptException(VariableArray.this.composeMessage("Index out of range for array children: " + this.index));
            }
            return VariableArray.this.array.get(this.index);
        }

        @Override
        public boolean isNull() {
            return this.index < 0 || this.index >= VariableArray.this.array.size() || VariableArray.this.array.get(this.index) == null;
        }
    }
}

