/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateImpl;

public class AtomEntryWriter {
    private static final int BUFFER_SIZE = 65536;
    private final CmisVersion cmisVersion;
    private final ObjectData object;
    private final ContentStream contentStream;
    private final InputStream stream;
    private final TypeDefinition typeDef;
    private final BulkUpdateImpl bulkUpdate;

    public AtomEntryWriter(ObjectData object, CmisVersion cmisVersion) {
        this(object, cmisVersion, null);
    }

    public AtomEntryWriter(ObjectData object, CmisVersion cmisVersion, ContentStream contentStream) {
        InputStream in;
        if (object == null || object.getProperties() == null) {
            throw new CmisInvalidArgumentException("Object and properties must not be null!");
        }
        if (contentStream != null && contentStream.getMimeType() == null) {
            throw new CmisInvalidArgumentException("Media type must be set if a stream is present!");
        }
        this.object = object;
        this.cmisVersion = cmisVersion;
        this.contentStream = contentStream;
        this.stream = contentStream != null && contentStream.getStream() != null ? (!((in = contentStream.getStream()) instanceof BufferedInputStream) && !(in instanceof ByteArrayInputStream) ? new BufferedInputStream(in, 65536) : in) : null;
        this.typeDef = null;
        this.bulkUpdate = null;
    }

    public AtomEntryWriter(TypeDefinition type, CmisVersion cmisVersion) {
        if (type == null) {
            throw new CmisInvalidArgumentException("Type must not be null!");
        }
        this.typeDef = type;
        this.cmisVersion = cmisVersion;
        this.object = null;
        this.contentStream = null;
        this.stream = null;
        this.bulkUpdate = null;
    }

    public AtomEntryWriter(BulkUpdateImpl bulkUpdate) {
        if (bulkUpdate == null) {
            throw new CmisInvalidArgumentException("Bulk update data must not be null!");
        }
        this.bulkUpdate = bulkUpdate;
        this.typeDef = null;
        this.cmisVersion = CmisVersion.CMIS_1_1;
        this.object = null;
        this.contentStream = null;
        this.stream = null;
    }

    public void write(OutputStream out) throws XMLStreamException, IOException {
        XMLStreamWriter writer = XMLUtils.createWriter((OutputStream)out);
        XMLUtils.startXmlDocument((XMLStreamWriter)writer);
        writer.writeStartElement("atom", "entry", "http://www.w3.org/2005/Atom");
        writer.writeNamespace("atom", "http://www.w3.org/2005/Atom");
        writer.writeNamespace("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        writer.writeNamespace("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        if (this.contentStream != null && this.contentStream.getFileName() != null) {
            writer.writeNamespace("chemistry", "http://chemistry.apache.org/");
        }
        XMLUtils.write((XMLStreamWriter)writer, (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"id", (String)"urn:uuid:00000000-0000-0000-0000-00000000000");
        XMLUtils.write((XMLStreamWriter)writer, (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"title", (String)this.getTitle());
        XMLUtils.write((XMLStreamWriter)writer, (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"updated", (GregorianCalendar)new GregorianCalendar(DateTimeHelper.GMT));
        if (this.stream != null) {
            writer.writeStartElement("cmisra", "content", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            XMLUtils.write((XMLStreamWriter)writer, (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"mediatype", (String)this.contentStream.getMimeType());
            if (this.contentStream.getFileName() != null) {
                XMLUtils.write((XMLStreamWriter)writer, (String)"chemistry", (String)"http://chemistry.apache.org/", (String)"filename", (String)this.contentStream.getFileName());
            }
            writer.writeStartElement("cmisra", "base64", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            this.writeContent(writer);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (this.object != null) {
            XMLConverter.writeObject((XMLStreamWriter)writer, (CmisVersion)this.cmisVersion, (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (ObjectData)this.object);
        }
        if (this.typeDef != null) {
            XMLConverter.writeTypeDefinition((XMLStreamWriter)writer, (CmisVersion)this.cmisVersion, (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (TypeDefinition)this.typeDef);
        }
        if (this.bulkUpdate != null) {
            XMLConverter.writeBulkUpdate((XMLStreamWriter)writer, (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (BulkUpdateImpl)this.bulkUpdate);
        }
        writer.writeEndElement();
        XMLUtils.endXmlDocument((XMLStreamWriter)writer);
    }

    private String getTitle() {
        PropertyData nameProperty;
        String result = "";
        if (this.object != null && (nameProperty = (PropertyData)this.object.getProperties().getProperties().get("cmis:name")) instanceof PropertyString) {
            result = (String)((PropertyString)nameProperty).getFirstValue();
        }
        if (this.typeDef != null && this.typeDef.getDisplayName() != null) {
            result = this.typeDef.getDisplayName();
        }
        if (this.bulkUpdate != null) {
            result = "Bulk Update Properties";
        }
        return result;
    }

    private void writeContent(XMLStreamWriter writer) throws XMLStreamException, IOException {
        int b;
        Base64.InputStream b64stream = new Base64.InputStream(this.stream, 1);
        char[] buffer = new char[65536];
        int pos = 0;
        while ((b = b64stream.read()) > -1) {
            buffer[pos++] = (char)(b & 0xFF);
            if (pos != buffer.length) continue;
            writer.writeCharacters(buffer, 0, buffer.length);
            pos = 0;
        }
        if (pos > 0) {
            writer.writeCharacters(buffer, 0, pos);
        }
    }
}

