/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import sun.awt.AWTAutoShutdown;

@TestOnly
@ApiStatus.Internal
public final class UITestUtil {
    private UITestUtil() {
    }

    public static boolean getAndSetHeadlessProperty() {
        if ("false".equals(System.getProperty("java.awt.headless"))) {
            return false;
        }
        UITestUtil.setHeadlessProperty(true);
        return true;
    }

    public static void setHeadlessProperty(boolean isHeadless) {
        System.setProperty("java.awt.headless", Boolean.toString(isHeadless));
    }

    public static <E extends Throwable> void runWithHeadlessProperty(boolean propertyValue, @NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            UITestUtil.$$$reportNull$$$0(0);
        }
        boolean old = Boolean.getBoolean("java.awt.headless");
        UITestUtil.setHeadlessProperty(propertyValue);
        try {
            runnable.run();
        }
        finally {
            UITestUtil.setHeadlessProperty(old);
        }
    }

    public static void setupEventQueue() {
        if (EventQueue.isDispatchThread()) {
            IdeEventQueue.getInstance();
        } else {
            UITestUtil.replaceIdeEventQueueSafely();
        }
    }

    public static void replaceIdeEventQueueSafely() {
        if (Toolkit.getDefaultToolkit().getSystemEventQueue() instanceof IdeEventQueue) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must not be called on EDT");
        }
        AWTAutoShutdown.getInstance().notifyThreadBusy(Thread.currentThread());
        StartupUiUtil.INSTANCE.pump();
        try {
            EventQueue.invokeAndWait(IdeEventQueue::getInstance);
            EventQueue.invokeAndWait(EmptyRunnable.getInstance());
            EventQueue.invokeAndWait(EmptyRunnable.getInstance());
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/testFramework/UITestUtil", "runWithHeadlessProperty"));
    }
}

