/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import java.util.Objects;

class Negation {
    static final NodePattern negated = NodePattern.N.withDependent("advmod", NodePattern.N.form("\u043d\u0435"));
    static final String NO_SPACE_NE_MESSAGE = "\u00ab\u041d\u0435\u00bb \u0431\u0435\u0437 \u043f\u0440\u043e\u0442\u0438\u0432\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u043b\u0438 \u0443\u0441\u0438\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u044b\u0447\u043d\u043e \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e";
    static final String NEGATION_NE_MESSAGE = "\u0414\u043b\u044f \u043e\u0442\u0440\u0438\u0446\u0430\u043d\u0438\u044f \u0431\u0435\u0437 \u0443\u0441\u0438\u043b\u0435\u043d\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u0443 \u00ab\u043d\u0435\u00bb";
    static final String NEGATION_NI_MESSAGE = "\u041e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043c\u0435\u0441\u0442\u043e\u0438\u043c\u0435\u043d\u0438\u044f \u043f\u0438\u0448\u0443\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e";
    private static final NodePattern whBy = NodePattern.or(RussianTreePatterns.whWord, NodePattern.N.form("\u043a\u0430\u043a")).directlyBefore(NodePattern.N.form("\u0431\u044b"));
    private static final NodePattern twoWordsInQuotes = NodePattern.N.noSpaceAfter().directlyBefore(RussianTreePatterns.quotes.closing()).withNeighbor(-2, RussianTreePatterns.quotes.opening().noSpaceAfter());

    Negation() {
    }

    static NodePattern neNi() {
        return NodePattern.or(NodePattern.N.form("\u043d\u0435").markAs("Ne").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e"))).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("\u043f\u0440\u0438\u0447[\u0435\u0451]\u043c")).and((ni, match) -> {
            Node next = Objects.requireNonNull(ni.nextNode());
            String split = next.form().substring(0, 3) + " " + next.form().substring(3);
            return match.withCorrector(NodeCorrector.replace(ni, "\u043d\u0438").join(NodeCorrector.replace(next, split)));
        }), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.inFormSequence(0, "\u043f\u0440\u0438", "\u0447[\u0435\u0451]\u043c"), NodePattern.or(NodePattern.N.inFormSequence(0, "\u0441", "\u0447\u0435\u043c"), NodePattern.N.inFormSequence(0, "\u0437\u0430", "\u0447\u0442\u043e")).withHead("case", NodePattern.N.withHead("obl", NodePattern.N.pos("VB:.*").noPos("VB:INF:.*")))).andNot(NodePattern.N.withNeighbor(2, CommonPatterns.HYPHEN_NODE))).correct(NodeCorrector.replace("\u043d\u0438")), NodePattern.N.withHead("advmod", RussianTreePatterns.clause.directlyAfter("Ne").andOr(NodePattern.N.withDependent("advmod|mark", RussianTreePatterns.whWord.before("Ne").noForm("\u0433\u0434\u0435|\u0447\u0442\u043e\u0431\u044b|\u043a\u043e\u0433\u0434\u0430|\u0447\u0442\u043e|\u043f\u043e\u0447\u0435\u043c\u0443|\u043a\u0430\u043a")).andOr(NodePattern.ROOT.withDependent("conj"), NodePattern.N.withHead("advcl", NodePattern.ROOT)).noHeadRelation("acl|csubj.*").andNot(NodePattern.N.pos("VB:INF.*").withDependent("nsubj.*", Case.Nom.posPattern)).noDependents("aux", NodePattern.N.form("\u0431\u044b")).noDependents("punct", NodePattern.N.form("[?!]")), CommonPatterns.possiblyConj(NodePattern.N.withDependent("advmod|mark", NodePattern.or(whBy, NodePattern.N.withDependent("advmod|mark", whBy))).withHeadRelation("advcl")))).correct(NodeCorrector.replace("\u043d\u0438"))).message("\u0414\u043b\u044f \u0443\u0441\u0438\u043b\u0435\u043d\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u0443 \u00ab\u043d\u0438\u00bb"), NodePattern.N.form("\u043d\u0438").beforeHead().withHead("advmod", NodePattern.N.pos("(NN|PNN|ADJ:MPR|ADV).*").noPos("Num:.*").noForm("\u043a\u043e\u0438\u043c").andNot(RussianTreePatterns.clause).andNot(NodePattern.ROOT).andNot(negated).noDependents("nmod|obl", NodePattern.N.withDependent("case", NodePattern.N.form("\u0431\u0435\u0437"))).andNot(NodePattern.N.withHead("nsubj.*|i?obj|obl|nmod", NodePattern.or(NodePattern.N.form("\u043d\u0435\u0442"), negated, NodePattern.N.withHead("xcomp|csubj|nsubj", NodePattern.or(negated, NodePattern.N.pos("PRDC").form("\u043d\u0435.+")))))).andNot(NodePattern.N.withHead("nsubj", NodePattern.N.pos("NN.*"))).andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("advmod", NodePattern.N.form("\u0442\u043e\u043b\u044c\u043a\u043e"))))).andNot(NodePattern.N.directlyBefore(twoWordsInQuotes)).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u043a\u0430\u043a")).directlyBefore(NodePattern.N.pos("ADV"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("case").directlyBeforeHead().directlyBefore(NodePattern.N.pos("PNN:.*")))).andNot(NodePattern.N.inSentenceWith(NodePattern.N.form("\u043d\u0438"))).and((ni, match) -> {
            Node next = ni.neighbor(1);
            String concat = "\u043d\u0438" + next.lowForm();
            TreeSupport support = ni.tree().treeSupport();
            return support.tagToken(concat).hasPos("ADJ.*|ADV|PNN.*") ? match.withCorrector(NodeCorrector.replaceNodes(ni, next, concat)).withMessage(NEGATION_NI_MESSAGE) : match.withCorrector(NodeCorrector.replace(ni, "\u043d\u0435")).withMessage(NEGATION_NE_MESSAGE);
        }));
    }

    static NodePattern neSeparation() {
        NodePattern reinforcement = NodePattern.N.form("\u043e\u0442\u043d\u044e\u0434\u044c|\u0434\u0430\u043b\u0435\u043a\u043e|\u043d\u0438\u0447\u0443\u0442\u044c|\u043d\u0438\u0441\u043a\u043e\u043b\u044c\u043a\u043e");
        NodePattern bolsheRazve = NodePattern.N.form("\u0431\u043e\u043b\u044c\u0448\u0435|\u043d\u043e|\u0440\u0430\u0437\u0432\u0435");
        NodePattern maybeReinforcement = NodePattern.or(reinforcement, NodePattern.N.form("\u0441\u043e\u0432\u0441\u0435\u043c|\u0432\u043e\u0432\u0441\u0435|\u0432\u043e\u043e\u0431\u0449\u0435|\u0434\u0430\u0432\u043d\u043e|\u0434\u0430\u0436\u0435|\u0443\u0436\u0435|\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e"));
        NodePattern opposingA = NodePattern.N.form("\u0430").directlyBefore(NodePattern.N.noForm("\u0442\u0430\u043a\u0436\u0435"));
        NodePattern withANo = NodePattern.N.withDependent("cc", RussianTreePatterns.aNo);
        NodePattern opposedNeX_aY = NodePattern.N.withDependent("conj", NodePattern.N.withDependent("cc", opposingA).andNot(NodePattern.N.pos("ADJ:Short.*").withDependent("advmod")).andNot(NodePattern.N.pos("ADV").noPos("ADJ.*|P?NN.*")).noDependents("nsubj.*|csubj.*|advcl"));
        NodePattern opposedNeX_noY = NodePattern.N.withDependent("conj", RussianTreePatterns.clause.and(withANo));
        NodePattern opposedY_aNe_X = NodePattern.N.withHeadRelation("conj").withDependent("cc", opposingA).andNot(NodePattern.N.pos(".*NN.*"));
        NodePattern opposedY_aNeX = NodePattern.N.withHead("conj", NodePattern.N.noDependents("advmod", NodePattern.N.form("\u043d\u0435")).noHeadRelation("csubj")).directlyAfter(NodePattern.N.form("\u0430")).andNot(NodePattern.N.pos(".*NN.*"));
        NodePattern dashedPhrase = NodePattern.N.withPhraseStart(RussianTreePatterns.dashes);
        NodePattern dashedOpposition = NodePattern.or(dashedPhrase.withHeadRelation("parataxis"), NodePattern.N.withDependent("parataxis", dashedPhrase));
        NodePattern anyOpposition = NodePattern.or(opposedY_aNe_X, dashedOpposition, opposedNeX_aY, opposedNeX_noY, withANo.withHeadRelation("conj"));
        NodePattern insideOpposed = NodePattern.N.inPhrase(anyOpposition.markAs("Opposed")).andNot(NodePattern.N.withHead(NodePattern.N.inPhrase(RussianTreePatterns.clause.withHead(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Opposed"))))));
        NodePattern notGoodBad = NodePattern.N.form("\u043d\u0435\u0445\u043e\u0440\u043e\u0448\u043e|\u043d\u0435\u043f\u043b\u043e\u0445\u043e");
        NodePattern goodBad = NodePattern.N.form("\u0445\u043e\u0440\u043e\u0448\u043e|\u043f\u043b\u043e\u0445\u043e");
        NodePattern goodOrBad = NodePattern.or(goodBad.withHead("conj", goodBad), goodBad.withDependent("conj", goodBad));
        NodePattern adjOrAdj = NodePattern.N.pos("ADJ:P.*").withHead("conj", negated.pos("ADJ:P.*"));
        NodePattern neSvyazSIT = NodePattern.N.lemma("\u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439").inFormSequence(1, "\u043d\u0435", ".*", "\u0441", "IT|\u0418\u0422|\u0438\u0442|\u0430\u0439\u0442\u0438");
        NodePattern niPhrase = NodePattern.or(NodePattern.N.lemma("\u043d\u0438\u0447\u0442\u043e|\u043d\u0438\u043a\u0442\u043e|\u043d\u0438\u0433\u0434\u0435|\u043d\u0438\u043a\u0443\u0434\u0430|\u043d\u0438\u0437\u0430\u0447\u0435\u043c|\u043d\u0438\u0441\u043a\u043e\u043b\u044c\u043a\u043e|\u043d\u0438\u043a\u0430\u043a\u043e\u0439|\u043d\u0438\u043a\u0430\u043a"), NodePattern.N.withDependent("advmod", NodePattern.N.form("\u043d\u0438")));
        NodePattern withDependentWords = CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("i?obj|obl.*|advmod", NodePattern.N.pos("P?NN.*|ADJ.*|ADV.*")), NodePattern.N.withDependent("obl.*|flat:foreign", NodePattern.N.noPos())));
        NodePattern degree = NodePattern.or(NodePattern.N.form("\u0432\u0435\u0441\u044c\u043c\u0430|\u044f\u0432\u043d\u043e|\u043e\u0447\u0435\u043d\u044c|\u043a\u0440\u0430\u0439\u043d\u0435|\u043f\u043e\u0447\u0442\u0438|\u0430\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u043e|\u0447\u0443\u0442\u044c|\u0447\u0440\u0435\u0437\u0432\u044b\u0447\u0430\u0439\u043d\u043e|\u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e|\u043a\u0430\u043f\u0435\u043b\u044c\u043a\u0443|\u043d\u0435\u0438\u0437\u043c\u0435\u0440\u0438\u043c\u043e|\u0434\u043e\u0432\u043e\u043b\u044c\u043d\u043e"), NodePattern.N.inFormSequence(2, "\u0432", "\u0432\u044b\u0441\u0448\u0435\u0439", "\u0441\u0442\u0435\u043f\u0435\u043d\u0438"));
        NodeCorrector.Relative splitNe = NodeCorrector.regexReplace("\u043d\u0435(.*)", "\u043d\u0435 $1");
        String oftenWithNe = "\u0431\u0435\u0437\u0440\u0430\u0437\u043b\u0438\u0447\u043d\u043e|\u0432\u0430\u0436\u043d\u043e|\u0432\u0435\u0440\u043d\u043e|\u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e|\u0432\u043a\u0443\u0441\u043d\u043e|\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e|\u0433\u0440\u0430\u043c\u043e\u0442\u043d\u043e|\u0433\u0443\u043c\u0430\u043d\u043d\u043e|\u0434\u0430\u0432\u043d\u043e|\u0434\u0430\u043b\u0435\u043a\u043e|\u0434\u0430\u0440\u043e\u043c|\u0434\u043e\u043b\u0433\u043e|\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e|\u0437\u0430\u043c\u0435\u0442\u043d\u043e|\u0437\u043d\u0430\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e|\u0438\u043d\u0442\u0435\u0440\u0435\u0441\u043d\u043e|\u0438\u0441\u043a\u0440\u0435\u043d\u043d\u043e|\u043a\u043e\u043c\u0444\u043e\u0440\u0442\u043d\u043e|\u043a\u0443\u0434\u0430|\u043b\u0435\u0433\u043a\u043e|\u043c\u0430\u043b\u043e|\u043c\u043d\u043e\u0433\u043e|\u043d\u0430\u0434\u043e\u043b\u0433\u043e|\u043e\u0431\u044b\u0447\u043d\u043e|\u043e\u0442\u043a\u0443\u0434\u0430|\u043f\u043b\u043e\u0445\u043e|\u043f\u043e\u043d\u044f\u0442\u043d\u043e|\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e|\u043f\u0440\u0438\u0432\u044b\u0447\u043d\u043e|\u043f\u0440\u0438\u043b\u0438\u0447\u043d\u043e|\u043f\u0440\u0438\u044f\u0442\u043d\u043e|\u043f\u0440\u043e\u0441\u0442\u043e|\u0440\u0430\u0432\u043d\u043e\u0434\u0443\u0448\u043d\u043e|\u0440\u0435\u0434\u043a\u043e|\u0441\u0435\u0440\u044c[\u0451\u0435]\u0437\u043d\u043e|\u0441\u043a\u043e\u043b\u044c\u043a\u043e|\u0441\u043b\u0430\u0434\u043a\u043e|\u0441\u043b\u043e\u0436\u043d\u043e|\u0441\u043b\u044b\u0448\u043d\u043e|\u0441\u043f\u0440\u0430\u0432\u0435\u0434\u043b\u0438\u0432\u043e|\u0442\u0440\u0443\u0434\u043d\u043e|\u0443\u0434\u0438\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e|\u0443\u0434\u043e\u0431\u043d\u043e|\u0445\u043e\u0440\u043e\u0448\u043e|\u044f\u0441\u043d\u043e";
        NodePattern notSeparateNe = NodePattern.N.noForm("\u043f\u0440\u043e\u0447\u044c|\u0441\u0438\u043b\u044c\u043d\u043e|\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e|\u0440\u0430\u0432\u043d\u043e").andNot(twoWordsInQuotes).andOr(NodePattern.N.pos("ADV").noPos("PT.*|PNN.*").form(oftenWithNe).noDependents(NodePattern.or(niPhrase, NodePattern.N.form("\u043d\u0435\u0442|\u043b\u0438"))).andNot(NodePattern.N.withDependent("obj", NodePattern.N.pos(".*:R.*")).noDependents("csubj", NodePattern.N.pos("VB:INF.*"))).andNot(NodePattern.N.noDependents("punct").withHead("conj", NodePattern.N.pos("PRDC").directlyAfter(NodePattern.N.form("\u043d\u0435")))).andNot(NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("csubj"))).andNot(goodOrBad).andNot(NodePattern.N.form("\u0442\u0440\u0443\u0434\u043d\u043e|\u043f\u0440\u043e\u0441\u0442\u043e").withHeadRelation("advmod|obl")).andNot(NodePattern.N.form("\u0442\u0440\u0443\u0434\u043d\u043e").withDependent("mark", NodePattern.N.form("\u0435\u0441\u043b\u0438"))).andNot(NodePattern.N.form("\u044f\u0441\u043d\u043e").noDependents("csubj")).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.form("\\?"))).message(NO_SPACE_NE_MESSAGE), NodePattern.N.pos("ADJ.*|PT.*").noPos("PT_Short.*").noPos("ADV").noForm("\u043d\u0443\u0436(\u0435\u043d|\u043d\u0430|\u043d\u043e|\u043d\u044b)").noLemma("\u0432\u0438\u043d\u043e\u0432\u0430\u0442\u044b\u0439").withHeadRelation("i?obj|obl|xcomp|acl|conj").andNot(withDependentWords).andNot(adjOrAdj).andNot(neSvyazSIT).andNot(NodePattern.N.withPrevSiblingIncludingOtherSide(negated)).andNot(NodePattern.N.withDependent("advmod", NodePattern.N.form("\u043d\u0435").withDependent("advmod", NodePattern.N.form("\u0443\u0436\u0435")))).message(NO_SPACE_NE_MESSAGE), NodePattern.N.form("\u0432\u0435\u0441\u0442\u044c").directlyBefore(RussianTreePatterns.whWord).message("\u00ab\u041d\u0435\u0432\u0435\u0441\u0442\u044c\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e"));
        String alwaysNe = "\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0439|\u043d\u0435\u0432\u0435\u0434\u043e\u043c\u044b\u0439|\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u043a|\u043d\u0435\u043e\u0441\u043f\u043e\u0440\u0438\u043c\u044b\u0439";
        return NodePattern.or(NodePattern.N.form("\u043d\u0435").andOr(NodePattern.N.directlyBeforeHead().includeIntoReport().withHead("advmod", NodePattern.N.includeIntoReport()), NodePattern.N.withDependent("fixed", NodePattern.N.directlyAfterHead()).reportEverythingTouched().withDependent("csubj")).andOr(NodePattern.N.withHead(notSeparateNe).andNot(NodePattern.N.directlyAfter(maybeReinforcement)), NodePattern.N.withDependent("fixed", notSeparateNe).andNot(NodePattern.N.directlyAfter(maybeReinforcement)), NodePattern.N.withHead(NodePattern.N.pos("ADJ.*|PT:.*").andNot(withDependentWords).and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("amod|root")))).directlyAfter(degree).message("\u00ab\u041d\u0435\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0440\u0435\u0447\u0438\u0439 \u043c\u0435\u0440\u044b \u0438 \u0441\u0442\u0435\u043f\u0435\u043d\u0438")).andNot(NodePattern.or(NodePattern.N.withDependent("advmod", bolsheRazve), NodePattern.N.directlyAfter(bolsheRazve))).andNot(NodePattern.N.withHead(insideOpposed)).andNot(NodePattern.N.withHead("advmod", goodOrBad)).and((ne, match) -> {
            Node next = ne.neighbor(1);
            String concat = "\u043d\u0435" + next.lowForm();
            TreeSupport support = ne.tree().treeSupport();
            return support.tagToken(concat).hasPos(".*") ? match.withCorrector(NodeCorrector.replaceNodes(ne, next, concat)) : null;
        }), NodePattern.N.form("\u043d\u0435.{3,}").noPos("VB.*").and(node -> Negation.tagWithoutNe(node).hasPos("(NN|ADJ|ADV|PT).*")).noLemma(alwaysNe).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u0434\u043e\u0432\u043e\u043b\u044c\u043d\u043e"))).andNot(NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u044f\u0449\u0438\u043c", "\u043e\u0442")).andOr(NodePattern.N.pos("ADV|ADJ.*").and((node, match) -> {
            Node prev = node.prevNode();
            Tree.Token withoutNe = Negation.tagWithoutNe(node);
            boolean participle = withoutNe.hasPos("PT:.*");
            if ((withoutNe.hasPos("PT:.*:DST:.*") || participle && node.hasHeadRelation("acl")) && withDependentWords.matches(node) && (prev == null || !prev.hasPos("ADV"))) {
                return match.withMessage("\u00ab\u041d\u0435\u00bb \u043f\u0440\u0438 \u043f\u0440\u0438\u0447\u0430\u0441\u0442\u0438\u044f\u0445 \u0441 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c\u0438 \u0441\u043b\u043e\u0432\u0430\u043c\u0438 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e");
            }
            if (reinforcement.matches(prev) && !participle) {
                return match.withMessage("\u00ab\u041d\u0435\u00bb \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0438\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u00ab" + prev.lowForm() + "\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e");
            }
            return null;
        }), NodePattern.or(opposedNeX_aY.noPos("NN.*").andNot(negated), opposedY_aNeX.andNot(negated), NodePattern.N.pos("ADV").directlyBefore(CommonPatterns.comma.directlyBefore(NodePattern.N.form("\u0430").directlyBefore(NodePattern.N.pos("ADV").withHeadRelation("conj"))))).message("\u00ab\u041d\u0435\u00bb \u043f\u0440\u0438 \u043f\u0440\u043e\u0442\u0438\u0432\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e"), NodePattern.N.withDependent(".*", niPhrase).noHeadRelation("nsubj").message("\u00ab\u041d\u0435\u00bb \u0432 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u0443\u0441\u0438\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u043b\u043e\u0432 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e")).correct(splitNe), NodePattern.N.form("\u043d\u0435.{3,}").noPos().noHeadRelation("flat:name").and(node -> Negation.tagWithoutNe(node).hasPos("(VB|DPT).*")).message("\u00ab\u041d\u0435\u00bb c \u0433\u043b\u0430\u0433\u043e\u043b\u0430\u043c\u0438 \u0438 \u0434\u0435\u0435\u043f\u0440\u0438\u0447\u0430\u0441\u0442\u0438\u044f\u043c\u0438 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e").correct(splitNe), notGoodBad.withDependent("conj", notGoodBad.markAs("Second").withDependent("cc", NodePattern.N.form("\u0438"))).message("\u00ab\u041d\u0435\u00bb \u043e\u0442\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u043e \u0444\u0440\u0430\u0437\u0430\u0445 \u0432\u0440\u043e\u0434\u0435 \u00ab\u043d\u0435 \u0445\u043e\u0440\u043e\u0448\u043e \u0438 \u043d\u0435 \u043f\u043b\u043e\u0445\u043e\u00bb").and((node, match) -> match.withCorrector(splitNe.eval(match.withAnchor(node)).join(splitNe.eval(match.withAnchor(match.getMarkedNode("Second")))))));
    }

    private static Tree.Token tagWithoutNe(Node node) {
        return node.tree().treeSupport().tagToken(node.form().substring(2));
    }
}

