/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.stubs.PyParameterListStub;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyParameterListImpl
extends PyBaseElementImpl<PyParameterListStub>
implements PyParameterList,
PsiListLikeElement {
    public PyParameterListImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyParameterListImpl(PyParameterListStub stub) {
        this(stub, (IStubElementType)PyStubElementTypes.PARAMETER_LIST);
    }

    public PyParameterListImpl(PyParameterListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyParameterList((PyParameterList)this);
    }

    public PyParameter @NotNull [] getParameters() {
        PyParameter[] pyParameterArray = (PyParameter[])this.getStubOrPsiChildren(PythonDialectsTokenSetProvider.getInstance().getParameterTokens(), (PsiElement[])new PyParameter[0]);
        if (pyParameterArray == null) {
            PyParameterListImpl.$$$reportNull$$$0(0);
        }
        return pyParameterArray;
    }

    public void addParameter(PyNamedParameter param) {
        PsiElement paren = this.getLastChild();
        if (paren != null && ")".equals(paren.getText())) {
            ASTNode beforeWhat = paren.getNode();
            PyParameter[] params = this.getParameters();
            boolean hasDefaultValue = param.hasDefaultValue();
            boolean isLast = true;
            for (PyParameter p : params) {
                PyNamedParameter named;
                if (!hasDefaultValue && p.hasDefaultValue()) {
                    beforeWhat = p.getNode();
                    isLast = false;
                    break;
                }
                if (!(p instanceof PyNamedParameter) || !(named = (PyNamedParameter)p).isKeywordContainer() && !named.isPositionalContainer()) continue;
                beforeWhat = p.getNode();
                isLast = false;
                break;
            }
            ASTNode previous = PyPsiUtils.getPrevNonWhitespaceSibling((ASTNode)beforeWhat);
            PyUtil.addListNode((PsiElement)this, (PsiElement)param, beforeWhat, !isLast || params.length == 0 || previous.getElementType() == PyTokenTypes.COMMA, isLast, beforeWhat.getElementType() != PyTokenTypes.RPAR);
        }
    }

    public boolean hasPositionalContainer() {
        for (PyParameter parameter : this.getParameters()) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isPositionalContainer()) continue;
            return true;
        }
        return false;
    }

    public boolean hasKeywordContainer() {
        for (PyParameter parameter : this.getParameters()) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isKeywordContainer()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PyNamedParameter findParameterByName(final @NotNull String name) {
        if (name == null) {
            PyParameterListImpl.$$$reportNull$$$0(1);
        }
        final Ref result = new Ref();
        ParamHelper.walkDownParamArray(this.getParameters(), new ParamHelper.ParamVisitor(this){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                if (name.equals(param.getName())) {
                    result.set((Object)param);
                }
            }
        });
        return (PyNamedParameter)result.get();
    }

    @NotNull
    public String getPresentableText(boolean includeDefaultValue, @Nullable TypeEvalContext context) {
        String string = ParamHelper.getPresentableText(this.getParameters(), includeDefaultValue, context);
        if (string == null) {
            PyParameterListImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PyCallable getContainingCallable() {
        PyCallable callable;
        PsiElement parent = this.getParentByStub();
        return parent instanceof PyCallable ? (callable = (PyCallable)parent) : null;
    }

    public void deleteChildInternal(@NotNull ASTNode node) {
        if (node == null) {
            PyParameterListImpl.$$$reportNull$$$0(3);
        }
        if (ArrayUtil.contains((Object)node.getPsi(), (Object[])this.getParameters())) {
            PyPsiUtils.deleteAdjacentCommaWithWhitespaces((PsiElement)this, (PsiElement)node.getPsi());
        }
        super.deleteChildInternal(node);
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<PyParameter> list = Arrays.asList(this.getParameters());
        if (list == null) {
            PyParameterListImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyParameterListImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyParameterListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findParameterByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

