/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.stats;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class AsynchronousSearchCountStats
implements Writeable,
ToXContentFragment {
    private final long runningCount;
    private final long persistedCount;
    private final long persistFailedCount;
    private final long completedCount;
    private final long failedCount;
    private final long throttledCount;
    private final long initializedCount;
    private final long cancelledCount;
    private final long submittedCount;

    public AsynchronousSearchCountStats(long runningCount, long persistedCount, long completedCount, long failedCount, long throttledCount, long persistFailedCount, long initializedCount, long submittedCount, long cancelledCount) {
        this.runningCount = runningCount;
        this.persistedCount = persistedCount;
        this.persistFailedCount = persistFailedCount;
        this.completedCount = completedCount;
        this.failedCount = failedCount;
        this.throttledCount = throttledCount;
        this.initializedCount = initializedCount;
        this.cancelledCount = cancelledCount;
        this.submittedCount = submittedCount;
    }

    public AsynchronousSearchCountStats(StreamInput in) throws IOException {
        this.runningCount = in.readVLong();
        this.persistedCount = in.readVLong();
        this.completedCount = in.readVLong();
        this.failedCount = in.readVLong();
        this.throttledCount = in.readVLong();
        this.persistFailedCount = in.readVLong();
        this.initializedCount = in.readVLong();
        this.cancelledCount = in.readVLong();
        this.submittedCount = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.runningCount);
        out.writeVLong(this.persistedCount);
        out.writeVLong(this.completedCount);
        out.writeVLong(this.failedCount);
        out.writeVLong(this.throttledCount);
        out.writeVLong(this.persistFailedCount);
        out.writeVLong(this.initializedCount);
        out.writeVLong(this.cancelledCount);
        out.writeVLong(this.submittedCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("asynchronous_search_stats");
        builder.field("submitted", this.submittedCount);
        builder.field("initialized", this.initializedCount);
        builder.field("running_current", this.runningCount);
        builder.field("persisted", this.persistedCount);
        builder.field("search_failed", this.failedCount);
        builder.field("search_completed", this.completedCount);
        builder.field("rejected", this.throttledCount);
        builder.field("persist_failed", this.persistFailedCount);
        builder.field("cancelled", this.cancelledCount);
        builder.endObject();
        return builder;
    }

    public long getRunningCount() {
        return this.runningCount;
    }

    public long getPersistedCount() {
        return this.persistedCount;
    }

    public long getCompletedCount() {
        return this.completedCount;
    }

    public long getFailedCount() {
        return this.failedCount;
    }

    public long getThrottledCount() {
        return this.throttledCount;
    }

    public long getInitializedCount() {
        return this.initializedCount;
    }

    public long getCancelledCount() {
        return this.cancelledCount;
    }

    public long getSubmittedCount() {
        return this.submittedCount;
    }

    static final class Fields {
        private static final String ASYNC_SEARCH_STATS = "asynchronous_search_stats";
        private static final String RUNNING = "running_current";
        private static final String PERSISTED = "persisted";
        private static final String PERSIST_FAILED = "persist_failed";
        private static final String FAILED = "search_failed";
        private static final String COMPLETED = "search_completed";
        private static final String REJECTED = "rejected";
        private static final String SUBMITTED = "submitted";
        private static final String INITIALIZED = "initialized";
        private static final String CANCELLED = "cancelled";

        Fields() {
        }
    }
}

