/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.script;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.MonitorRunResult;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.authuser.User;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0016J\u0016\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R&\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u001c\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R#\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/opensearch/alerting/script/TriggerExecutionContext;", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "results", "", "", "", "periodStart", "Ljava/time/Instant;", "periodEnd", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "<init>", "(Lorg/opensearch/commons/alerting/model/Monitor;Ljava/util/List;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Exception;Lorg/opensearch/common/settings/ClusterSettings;)V", "trigger", "Lorg/opensearch/commons/alerting/model/Trigger;", "monitorRunResult", "Lorg/opensearch/commons/alerting/model/MonitorRunResult;", "(Lorg/opensearch/commons/alerting/model/Monitor;Lorg/opensearch/commons/alerting/model/Trigger;Lorg/opensearch/commons/alerting/model/MonitorRunResult;Lorg/opensearch/common/settings/ClusterSettings;)V", "getMonitor", "()Lorg/opensearch/commons/alerting/model/Monitor;", "getResults", "()Ljava/util/List;", "getPeriodStart", "()Ljava/time/Instant;", "getPeriodEnd", "getError", "()Ljava/lang/Exception;", "getClusterSettings", "()Lorg/opensearch/common/settings/ClusterSettings;", "templateResults", "getTemplateResults", "asTemplateArg", "opensearch-alerting"})
public abstract class TriggerExecutionContext {
    @NotNull
    private final Monitor monitor;
    @NotNull
    private final List<Map<String, Object>> results;
    @NotNull
    private final Instant periodStart;
    @NotNull
    private final Instant periodEnd;
    @Nullable
    private final Exception error;
    @NotNull
    private final ClusterSettings clusterSettings;

    public TriggerExecutionContext(@NotNull Monitor monitor, @NotNull List<? extends Map<String, ? extends Object>> results, @NotNull Instant periodStart, @NotNull Instant periodEnd, @Nullable Exception error, @NotNull ClusterSettings clusterSettings) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        this.monitor = monitor;
        this.results = results;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.error = error;
        this.clusterSettings = clusterSettings;
    }

    public /* synthetic */ TriggerExecutionContext(Monitor monitor, List list, Instant instant, Instant instant2, Exception exception, ClusterSettings clusterSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            exception = null;
        }
        this(monitor, list, instant, instant2, exception, clusterSettings);
    }

    @NotNull
    public Monitor getMonitor() {
        return this.monitor;
    }

    @NotNull
    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    @NotNull
    public Instant getPeriodStart() {
        return this.periodStart;
    }

    @NotNull
    public Instant getPeriodEnd() {
        return this.periodEnd;
    }

    @Nullable
    public Exception getError() {
        return this.error;
    }

    @NotNull
    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    @NotNull
    public final List<Map<String, Object>> getTemplateResults() {
        List resultsAllowedRoles = (List)this.getClusterSettings().getOrNull(AlertingSettings.Companion.getNOTIFICATION_CONTEXT_RESULTS_ALLOWED_ROLES());
        if (resultsAllowedRoles == null) {
            return this.getResults();
        }
        User user = this.getMonitor().getUser();
        Intrinsics.checkNotNull((Object)user);
        List userRoles = user.getRoles();
        Iterable iterable = resultsAllowedRoles;
        Intrinsics.checkNotNull((Object)userRoles);
        return !((Collection)CollectionsKt.intersect((Iterable)iterable, (Iterable)userRoles)).isEmpty() ? this.getResults() : CollectionsKt.emptyList();
    }

    public TriggerExecutionContext(@NotNull Monitor monitor, @NotNull Trigger trigger, @NotNull MonitorRunResult<?> monitorRunResult, @NotNull ClusterSettings clusterSettings) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter(monitorRunResult, (String)"monitorRunResult");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        this(monitor, monitorRunResult.getInputResults().getResults(), monitorRunResult.getPeriodStart(), monitorRunResult.getPeriodEnd(), monitorRunResult.scriptContextError(trigger), clusterSettings);
    }

    @NotNull
    public Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"monitor", (Object)this.getMonitor().asTemplateArg()), TuplesKt.to((Object)"results", this.getTemplateResults()), TuplesKt.to((Object)"periodStart", (Object)this.getPeriodStart()), TuplesKt.to((Object)"periodEnd", (Object)this.getPeriodEnd()), TuplesKt.to((Object)"error", (Object)this.getError())};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

