/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.opensearch.Version;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.Loggers;
import org.opensearch.index.merge.MergedSegmentTransferTracker;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.transport.TransportService;

public class MergedSegmentWarmer
implements IndexWriter.IndexReaderWarmer {
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;
    private final IndexShard indexShard;
    private final MergedSegmentTransferTracker mergedSegmentTransferTracker;
    private final Logger logger;

    public MergedSegmentWarmer(TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService, IndexShard indexShard) {
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
        this.indexShard = indexShard;
        this.mergedSegmentTransferTracker = indexShard.mergedSegmentTransferTracker();
        this.logger = Loggers.getLogger(this.getClass(), indexShard.shardId(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warm(LeafReader leafReader) throws IOException {
        long startTime = System.currentTimeMillis();
        long elapsedTime = -1L;
        boolean shouldWarm = false;
        try {
            SegmentCommitInfo segmentCommitInfo = this.segmentCommitInfo(leafReader);
            shouldWarm = this.shouldWarm(segmentCommitInfo);
            if (!shouldWarm) {
                return;
            }
            this.mergedSegmentTransferTracker.incrementTotalWarmInvocationsCount();
            this.mergedSegmentTransferTracker.incrementOngoingWarms();
            this.logger.trace(() -> new ParameterizedMessage("Warming segment: {}", (Object)segmentCommitInfo));
            this.indexShard.publishMergedSegment(segmentCommitInfo);
            long finalElapsedTime = elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.trace(() -> {
                long segmentSize = -1L;
                try {
                    segmentSize = segmentCommitInfo.sizeInBytes();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new ParameterizedMessage("Completed segment warming for {}. Size: {}B, Timing: {}ms", new Object[]{segmentCommitInfo.info.name, segmentSize, finalElapsedTime});
            });
        }
        catch (Throwable t) {
            this.logger.warn(() -> new ParameterizedMessage("Failed to warm segment. Continuing. {}", (Object)this.segmentCommitInfo(leafReader)), t);
            this.mergedSegmentTransferTracker.incrementTotalWarmFailureCount();
        }
        finally {
            if (shouldWarm) {
                if (elapsedTime == -1L) {
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                this.mergedSegmentTransferTracker.addTotalWarmTimeMillis(elapsedTime);
                this.mergedSegmentTransferTracker.decrementOngoingWarms();
            }
        }
    }

    SegmentCommitInfo segmentCommitInfo(LeafReader leafReader) {
        assert (leafReader instanceof SegmentReader);
        assert (this.indexShard.indexSettings().isSegRepLocalEnabled() || this.indexShard.indexSettings().isRemoteStoreEnabled());
        try {
            return ((SegmentReader)leafReader).getSegmentInfo();
        }
        catch (Throwable e) {
            this.logger.warn("Unable to get segment info from leafReader. Continuing.", e);
            return null;
        }
    }

    boolean shouldWarm(SegmentCommitInfo segmentCommitInfo) throws IOException {
        double threshold;
        Version minNodeVersion = this.clusterService.state().nodes().getMinNodeVersion();
        if (Version.V_3_4_0.compareTo(minNodeVersion) > 0) {
            return false;
        }
        if (!this.indexShard.getRecoverySettings().isMergedSegmentReplicationWarmerEnabled()) {
            return false;
        }
        if (segmentCommitInfo.info == null || segmentCommitInfo.info.dir == null) {
            return false;
        }
        long segmentSize = segmentCommitInfo.sizeInBytes();
        if ((double)segmentSize < (threshold = (double)this.indexShard.getRecoverySettings().getMergedSegmentWarmerMinSegmentSizeThreshold().getBytes())) {
            this.logger.trace(() -> new ParameterizedMessage("Skipping warm for segment {}. SegmentSize {}B is less than the configured threshold {}B.", new Object[]{segmentCommitInfo.info.name, segmentSize, threshold}));
            return false;
        }
        return true;
    }
}

