/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.opensearch.common.unit.Fuzziness;
import org.opensearch.index.query.FuzzyQueryBuilder;
import org.opensearch.protobufs.FuzzyQuery;
import org.opensearch.transport.grpc.proto.response.common.FieldValueProtoUtils;

class FuzzyQueryBuilderProtoUtils {
    private FuzzyQueryBuilderProtoUtils() {
    }

    static FuzzyQueryBuilder fromProto(FuzzyQuery fuzzyQueryProto) {
        String fieldName = fuzzyQueryProto.getField();
        Object value = FieldValueProtoUtils.fromProto(fuzzyQueryProto.getValue(), false);
        Fuzziness fuzziness = FuzzyQueryBuilder.DEFAULT_FUZZINESS;
        int prefixLength = 0;
        int maxExpansions = 50;
        boolean transpositions = true;
        String rewrite = null;
        String queryName = null;
        float boost = 1.0f;
        if (fuzzyQueryProto.hasBoost()) {
            boost = fuzzyQueryProto.getBoost();
        }
        if (fuzzyQueryProto.hasFuzziness()) {
            org.opensearch.protobufs.Fuzziness fuzzinessProto = fuzzyQueryProto.getFuzziness();
            if (fuzzinessProto.hasString()) {
                fuzziness = Fuzziness.build((Object)fuzzinessProto.getString());
            } else if (fuzzinessProto.hasInt32()) {
                fuzziness = Fuzziness.fromEdits((int)fuzzinessProto.getInt32());
            }
        }
        if (fuzzyQueryProto.hasPrefixLength()) {
            prefixLength = fuzzyQueryProto.getPrefixLength();
        }
        if (fuzzyQueryProto.hasMaxExpansions()) {
            maxExpansions = fuzzyQueryProto.getMaxExpansions();
        }
        if (fuzzyQueryProto.hasTranspositions()) {
            transpositions = fuzzyQueryProto.getTranspositions();
        }
        if (fuzzyQueryProto.hasRewrite()) {
            rewrite = fuzzyQueryProto.getRewrite();
        }
        if (fuzzyQueryProto.hasXName()) {
            queryName = fuzzyQueryProto.getXName();
        }
        return (FuzzyQueryBuilder)((FuzzyQueryBuilder)new FuzzyQueryBuilder(fieldName, value).fuzziness(fuzziness).prefixLength(prefixLength).maxExpansions(maxExpansions).transpositions(transpositions).rewrite(rewrite).boost(boost)).queryName(queryName);
    }
}

