/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.GrantConstants;
import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.User;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;

class UserManager
implements GrantConstants {
    User sysUser = null;
    private HashMappedList userList;
    private GranteeManager granteeManager;

    UserManager(Database database) throws HsqlException {
        this.granteeManager = database.getGranteeManager();
        this.userList = new HashMappedList();
        this.createUser("PUBLIC", null);
        this.sysUser = this.createUser("_SYSTEM", null);
        this.sysUser.getGrantee().setAdminDirect();
    }

    User createUser(String string, String string2) throws HsqlException {
        if (string == null) {
            Trace.doAssert(false, Trace.getMessage(236));
        }
        Grantee grantee = this.granteeManager.addGrantee(string);
        User user = new User(string, string2, grantee);
        if ("_SYSTEM".equals(string)) {
            return user;
        }
        boolean bl = this.userList.add(string, user);
        if (!bl) {
            throw Trace.error(36, string);
        }
        return user;
    }

    void dropUser(String string) throws HsqlException {
        boolean bl = GranteeManager.isReserved(string);
        Trace.check(!bl, 231, string);
        boolean bl2 = this.granteeManager.removeGrantee(string);
        Trace.check(bl2, 232, string);
        User user = (User)this.userList.remove(string);
        Trace.check(user != null, 37, string);
    }

    User getUser(String string, String string2) throws HsqlException {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("PUBLIC")) {
            throw Trace.error(33);
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        User user = this.get(string);
        user.checkPassword(string2);
        return user;
    }

    HashMappedList getUsers() {
        return this.userList;
    }

    boolean exists(String string) {
        return this.userList.get(string) != null;
    }

    User get(String string) throws HsqlException {
        User user = (User)this.userList.get(string);
        if (user == null) {
            throw Trace.error(37, string);
        }
        return user;
    }

    HsqlArrayList listVisibleUsers(Session session, boolean bl) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl2 = session.isAdmin();
        String string = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return hsqlArrayList;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user == null) continue;
            String string2 = user.getName();
            if ("PUBLIC".equals(string2)) {
                if (!bl) continue;
                hsqlArrayList.add(user);
                continue;
            }
            if (bl2) {
                hsqlArrayList.add(user);
                continue;
            }
            if (!string.equals(string2)) continue;
            hsqlArrayList.add(user);
        }
        return hsqlArrayList;
    }

    static String[] getRightsArray(int n) {
        return GranteeManager.getRightsArray(n);
    }

    void removeDbObject(Object object) {
        this.granteeManager.removeDbObject(object);
    }

    User getSysUser() {
        return this.sysUser;
    }

    public synchronized void removeSchemaReference(SchemaManager.Schema schema) {
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user.getInitialSchema() != schema.name) continue;
            user.setInitialSchema(null);
        }
    }
}

