/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;

public class TouchCommand
extends AbstractDataCommand {
    public static final byte COMMAND_ID = 66;
    private boolean touchEvenIfExpired;

    public TouchCommand() {
    }

    public TouchCommand(Object key, int segment, long flagBitSet, boolean touchEvenIfExpired) {
        super(key, segment, flagBitSet);
        this.touchEvenIfExpired = touchEvenIfExpired;
    }

    @Override
    public byte getCommandId() {
        return 66;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        UnsignedNumeric.writeUnsignedInt((DataOutput)output, (int)this.segment);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeBoolean(this.touchEvenIfExpired);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((DataInput)input);
        this.setFlagsBitSet(input.readLong());
        this.touchEvenIfExpired = input.readBoolean();
    }

    public boolean isTouchEvenIfExpired() {
        return this.touchEvenIfExpired;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitTouchCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }
}

