/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class SubjectAlternativeNamesExtension
extends X509CertificateExtension {
    private final List<GeneralName> subjectAlternativeNames;

    public SubjectAlternativeNamesExtension(boolean critical, List<GeneralName> subjectAlternativeNames) {
        super(critical);
        Assert.checkNotNullParam((String)"subjectAlternativeNames", subjectAlternativeNames);
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    @Override
    public String getId() {
        return "2.5.29.17";
    }

    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (GeneralName name : this.subjectAlternativeNames) {
            name.encodeTo(encoder);
        }
        encoder.endSequence();
    }
}

