/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.util.Vector;
import javax.print.PrintService;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeUpdater;

class ServiceNotifier
extends Thread {
    private PrintService service;
    private Vector listeners;
    private boolean stop = false;
    private PrintServiceAttributeSet lastSet;

    ServiceNotifier(PrintService printService) {
        super(printService.getName() + " notifier");
        this.service = printService;
        this.listeners = new Vector();
        try {
            this.setPriority(4);
            this.setDaemon(true);
            this.start();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(PrintServiceAttributeListener printServiceAttributeListener) {
        ServiceNotifier serviceNotifier = this;
        synchronized (serviceNotifier) {
            if (printServiceAttributeListener == null || this.listeners == null) {
                return;
            }
            this.listeners.add(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        ServiceNotifier serviceNotifier = this;
        synchronized (serviceNotifier) {
            if (printServiceAttributeListener == null || this.listeners == null) {
                return;
            }
            this.listeners.remove(printServiceAttributeListener);
        }
    }

    boolean isEmpty() {
        return this.listeners == null || this.listeners.isEmpty();
    }

    void stopNotifier() {
        this.stop = true;
    }

    void wake() {
        try {
            this.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l = 15000L;
        long l2 = 2000L;
        while (!this.stop) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ServiceNotifier serviceNotifier = this;
            synchronized (serviceNotifier) {
                PrintServiceAttributeSet printServiceAttributeSet;
                if (this.listeners == null) {
                    continue;
                }
                long l3 = System.currentTimeMillis();
                if (this.listeners != null && (printServiceAttributeSet = this.service instanceof AttributeUpdater ? ((AttributeUpdater)((Object)this.service)).getUpdatedAttributes() : this.service.getAttributes()) != null && !printServiceAttributeSet.isEmpty()) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        PrintServiceAttributeListener printServiceAttributeListener = (PrintServiceAttributeListener)this.listeners.elementAt(i);
                        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet(printServiceAttributeSet);
                        PrintServiceAttributeEvent printServiceAttributeEvent = new PrintServiceAttributeEvent(this.service, hashPrintServiceAttributeSet);
                        printServiceAttributeListener.attributeUpdate(printServiceAttributeEvent);
                    }
                }
                if ((l2 = (System.currentTimeMillis() - l3) * 10L) < l) {
                    l2 = l;
                }
            }
        }
    }
}

