/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Document;
import org.jdesktop.swingx.JXSearchField;
import org.jdesktop.swingx.plaf.BuddyLayoutAndBorder;
import org.jdesktop.swingx.plaf.BuddyTextFieldUI;
import org.jdesktop.swingx.prompt.BuddySupport;
import org.jdesktop.swingx.search.NativeSearchFieldSupport;

public class SearchFieldUI
extends BuddyTextFieldUI {
    protected JXSearchField searchField;
    private Handler handler;
    public static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

    public SearchFieldUI(TextUI delegate) {
        super(delegate);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    public void installUI(JComponent c) {
        this.searchField = (JXSearchField)c;
        super.installUI(c);
        this.installDefaults();
        this.layoutButtons();
        this.configureListeners();
    }

    private void configureListeners() {
        if (this.isNativeSearchField()) {
            this.popupButton().removeActionListener(this.getHandler());
            this.searchField.removePropertyChangeListener(this.getHandler());
        } else {
            this.popupButton().addActionListener(this.getHandler());
            this.searchField.addPropertyChangeListener(this.getHandler());
        }
        this.searchField.getDocument().addDocumentListener(this.getHandler());
    }

    private boolean isNativeSearchField() {
        return NativeSearchFieldSupport.isNativeSearchField(this.searchField);
    }

    @Override
    protected BuddyLayoutAndBorder createBuddyLayoutAndBorder() {
        return new BuddyLayoutAndBorder(){

            @Override
            protected void replaceBorderIfNecessary() {
                if (!SearchFieldUI.this.isNativeSearchField()) {
                    super.replaceBorderIfNecessary();
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                if (SearchFieldUI.this.isNativeSearchField()) {
                    return new Dimension();
                }
                return super.preferredLayoutSize(parent);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                Insets insets = super.getBorderInsets(c);
                if (SearchFieldUI.this.searchField != null && !SearchFieldUI.this.isNativeSearchField()) {
                    if (SearchFieldUI.this.isMacLayoutStyle()) {
                        if (!SearchFieldUI.this.clearButton().isVisible()) {
                            insets.right += SearchFieldUI.this.clearButton().getPreferredSize().width;
                        }
                    } else {
                        int overSize;
                        JButton refButton = SearchFieldUI.this.popupButton();
                        if (SearchFieldUI.this.searchField.getFindPopupMenu() == null ^ SearchFieldUI.this.searchField.isUseSeperatePopupButton()) {
                            refButton = SearchFieldUI.this.searchButton();
                        }
                        int clearWidth = SearchFieldUI.this.clearButton().getPreferredSize().width;
                        int refWidth = refButton.getPreferredSize().width;
                        int n = overSize = SearchFieldUI.this.clearButton().isVisible() ? refWidth - clearWidth : clearWidth - refWidth;
                        if (overSize > 0) {
                            insets.right += overSize;
                        }
                    }
                }
                return insets;
            }
        };
    }

    private void layoutButtons() {
        BuddySupport.removeAll(this.searchField);
        if (this.isNativeSearchField()) {
            return;
        }
        if (this.isMacLayoutStyle()) {
            BuddySupport.addLeft(this.searchButton(), this.searchField);
        } else {
            BuddySupport.addRight(this.searchButton(), this.searchField);
        }
        BuddySupport.addRight(this.clearButton(), this.searchField);
        if (this.usingSeperatePopupButton()) {
            BuddySupport.addRight(BuddySupport.createGap(this.getPopupOffset()), this.searchField);
        }
        if (this.usingSeperatePopupButton() || !this.isMacLayoutStyle()) {
            BuddySupport.addRight(this.popupButton(), this.searchField);
        } else {
            BuddySupport.addLeft(this.popupButton(), this.searchField);
        }
    }

    private boolean isMacLayoutStyle() {
        return this.searchField.getLayoutStyle() == JXSearchField.LayoutStyle.MAC;
    }

    protected void installDefaults() {
        if (this.isNativeSearchField()) {
            return;
        }
        if (UIManager.getBoolean("SearchField.useSeperatePopupButton")) {
            this.searchField.customSetUIProperty("useSeperatePopupButton", Boolean.TRUE);
        } else {
            this.searchField.customSetUIProperty("useSeperatePopupButton", Boolean.FALSE);
        }
        this.searchField.customSetUIProperty("layoutStyle", UIManager.get("SearchField.layoutStyle"));
        this.searchField.customSetUIProperty("promptFontStyle", UIManager.get("SearchField.promptFontStyle"));
        if (this.shouldReplaceResource(this.searchField.getOuterMargin())) {
            this.searchField.setOuterMargin(UIManager.getInsets("SearchField.buttonMargin"));
        }
        this.updateButtons();
        if (this.shouldReplaceResource(this.clearButton().getIcon())) {
            this.clearButton().setIcon(UIManager.getIcon("SearchField.clearIcon"));
        }
        if (this.shouldReplaceResource(this.clearButton().getPressedIcon())) {
            this.clearButton().setPressedIcon(UIManager.getIcon("SearchField.clearPressedIcon"));
        }
        if (this.shouldReplaceResource(this.clearButton().getRolloverIcon())) {
            this.clearButton().setRolloverIcon(UIManager.getIcon("SearchField.clearRolloverIcon"));
        }
        this.searchButton().setIcon(this.getNewIcon(this.searchButton().getIcon(), "SearchField.icon"));
        this.popupButton().setIcon(this.getNewIcon(this.popupButton().getIcon(), "SearchField.popupIcon"));
        this.popupButton().setRolloverIcon(this.getNewIcon(this.popupButton().getRolloverIcon(), "SearchField.popupRolloverIcon"));
        this.popupButton().setPressedIcon(this.getNewIcon(this.popupButton().getPressedIcon(), "SearchField.popupPressedIcon"));
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.searchField.removePropertyChangeListener(this.getHandler());
        this.searchField.getDocument().removeDocumentListener(this.getHandler());
        this.popupButton().removeActionListener(this.getHandler());
        this.searchField.setLayout(null);
        this.searchField.removeAll();
        this.searchField = null;
    }

    protected boolean shouldReplaceResource(Object o) {
        return o == null || o instanceof UIResource;
    }

    protected Icon getNewIcon(Icon icon, String resKey) {
        Icon uiIcon = UIManager.getIcon(resKey);
        if (this.shouldReplaceResource(icon)) {
            return uiIcon;
        }
        return icon;
    }

    protected final JButton clearButton() {
        return this.searchField.getCancelButton();
    }

    protected final JButton searchButton() {
        return this.searchField.getFindButton();
    }

    protected final JButton popupButton() {
        return this.searchField.getPopupButton();
    }

    public boolean usingSeperatePopupButton() {
        return this.searchField.isUseSeperatePopupButton() && this.searchField.getFindPopupMenu() != null;
    }

    protected int getPopupOffset() {
        if (this.usingSeperatePopupButton()) {
            return UIManager.getInt("SearchField.popupOffset");
        }
        return 0;
    }

    protected void updateButtons() {
        this.clearButton().setVisible((!this.searchField.isRegularSearchMode() || this.searchField.isMacLayoutStyle()) && this.hasText());
        boolean clearNotHere = this.searchField.isMacLayoutStyle() || !this.clearButton().isVisible();
        this.searchButton().setVisible((this.searchField.getFindPopupMenu() == null || this.usingSeperatePopupButton()) && clearNotHere);
        this.popupButton().setVisible(this.searchField.getFindPopupMenu() != null && (clearNotHere || this.usingSeperatePopupButton()));
        if (this.searchField.isRegularSearchMode()) {
            this.searchButton().setRolloverIcon(this.getNewIcon(this.searchButton().getRolloverIcon(), "SearchField.rolloverIcon"));
            this.searchButton().setPressedIcon(this.getNewIcon(this.searchButton().getPressedIcon(), "SearchField.pressedIcon"));
        } else {
            if (this.shouldReplaceResource(this.searchButton().getRolloverIcon())) {
                this.searchButton().setRolloverIcon(null);
            }
            if (this.shouldReplaceResource(this.searchButton().getPressedIcon())) {
                this.searchButton().setPressedIcon(null);
            }
        }
    }

    private boolean hasText() {
        return this.searchField.getText() != null && this.searchField.getText().length() > 0;
    }

    class Handler
    implements PropertyChangeListener,
    ActionListener,
    DocumentListener {
        Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            Object src = evt.getSource();
            if (src.equals(SearchFieldUI.this.searchField)) {
                if ("findPopupMenu".equals(prop) || "searchMode".equals(prop) || "useSeperatePopupButton".equals(prop) || "searchMode".equals(prop) || "layoutStyle".equals(prop)) {
                    SearchFieldUI.this.layoutButtons();
                    SearchFieldUI.this.updateButtons();
                } else if ("document".equals(prop)) {
                    Document doc = (Document)evt.getOldValue();
                    if (doc != null) {
                        doc.removeDocumentListener(this);
                    }
                    if ((doc = (Document)evt.getNewValue()) != null) {
                        doc.addDocumentListener(this);
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (SearchFieldUI.this.searchField.getFindPopupMenu() != null) {
                Component src = "searchField".equals(UIManager.getString("SearchField.popupSource")) ? SearchFieldUI.this.searchField : (Component)e2.getSource();
                Rectangle r2 = SwingUtilities.getLocalBounds(src);
                int popupWidth = SearchFieldUI.this.searchField.getFindPopupMenu().getPreferredSize().width;
                int x = SearchFieldUI.this.searchField.isVistaLayoutStyle() || SearchFieldUI.this.usingSeperatePopupButton() ? r2.x + r2.width - popupWidth : r2.x;
                SearchFieldUI.this.searchField.getFindPopupMenu().show(src, x, r2.y + r2.height);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.update();
        }

        private void update() {
            if (SearchFieldUI.this.searchField.isInstantSearchMode()) {
                SearchFieldUI.this.searchField.getInstantSearchTimer().stop();
                if (SearchFieldUI.this.searchField.getInstantSearchDelay() > 0) {
                    SearchFieldUI.this.searchField.getInstantSearchTimer().setInitialDelay(SearchFieldUI.this.searchField.getInstantSearchDelay());
                    SearchFieldUI.this.searchField.getInstantSearchTimer().start();
                } else {
                    SearchFieldUI.this.searchField.postActionEvent();
                }
            }
            SearchFieldUI.this.updateButtons();
        }
    }
}

