/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dsl;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.UrlBasedRepositoryModelImpl;
import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependencyRepository;
import com.intellij.externalSystem.ExternalDependencyModificator;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.dsl.GradleDependencyModificatorKt;
import org.jetbrains.plugins.gradle.dsl.RepositoriesWithShorthandMethods;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0015\u0010$\u001a\u00020\u000b2\u000b\u0010\u0015\u001a\u00070%\u00a2\u0006\u0002\b&H\u0002J\f\u0010'\u001a\u00020\u0010*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gradle/dsl/GradleDependencyModificator;", "Lcom/intellij/externalSystem/ExternalDependencyModificator;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "supports", "", "module", "Lcom/intellij/openapi/module/Module;", "addDependency", "", "descriptor", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "checkDescriptor", "getConfigurationName", "", "updateDependency", "oldDescriptor", "newDescriptor", "updateVariableOrValue", "model", "Lcom/android/tools/idea/gradle/dsl/api/ext/ResolvedPropertyModel;", "value", "removeDependency", "addRepository", "repository", "Lcom/intellij/buildsystem/model/unified/UnifiedDependencyRepository;", "deleteRepository", "declaredDependencies", "", "Lcom/intellij/buildsystem/model/DeclaredDependency;", "declaredRepositories", "throwFailToModify", "", "logMissingModel", "applyChanges", "Lcom/android/tools/idea/gradle/dsl/api/GradleBuildModel;", "Lorg/jetbrains/annotations/Nullable;", "trimLastSlash", "intellij.gradle.dependencyUpdater"})
@SourceDebugExtension(value={"SMAP\nGradleDependencyModificator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDependencyModificator.kt\norg/jetbrains/plugins/gradle/dsl/GradleDependencyModificator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,196:1\n1#2:197\n1#2:213\n1#2:226\n13#3:198\n60#3,5:229\n1563#4:199\n1634#4,3:200\n1617#4,9:203\n1869#4:212\n1870#4:214\n1626#4:215\n1617#4,9:216\n1869#4:225\n1870#4:227\n1626#4:228\n140#5:234\n129#5,5:235\n*S KotlinDebug\n*F\n+ 1 GradleDependencyModificator.kt\norg/jetbrains/plugins/gradle/dsl/GradleDependencyModificator\n*L\n169#1:213\n170#1:226\n68#1:198\n184#1:229,5\n154#1:199\n154#1:200,3\n169#1:203,9\n169#1:212\n169#1:214\n169#1:215\n170#1:216,9\n170#1:225\n170#1:227\n170#1:228\n193#1:234\n193#1:235,5\n*E\n"})
public final class GradleDependencyModificator
implements ExternalDependencyModificator {
    @NotNull
    private final Project myProject;

    public GradleDependencyModificator(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)ExternalSystemModulePropertyManager.Companion.getInstance(module).getExternalSystemId(), (Object)GradleConstants.SYSTEM_ID.getId());
    }

    public void addDependency(@NotNull Module module, @NotNull UnifiedDependency descriptor) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.checkDescriptor(descriptor);
        String string = descriptor.getCoordinates().getArtifactId();
        Intrinsics.checkNotNull((Object)string);
        ArtifactDependencySpec artifactDependencySpec = ArtifactDependencySpec.create((String)string, (String)descriptor.getCoordinates().getGroupId(), (String)descriptor.getCoordinates().getVersion());
        Intrinsics.checkNotNullExpressionValue((Object)artifactDependencySpec, (String)"create(...)");
        ArtifactDependencySpec artifactSpec = artifactDependencySpec;
        GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
        if (gradleBuildModel == null) {
            this.throwFailToModify(module);
            throw new KotlinNothingValueException();
        }
        GradleBuildModel model = gradleBuildModel;
        String configurationName = this.getConfigurationName(descriptor);
        DependenciesModel dependenciesModel = model.dependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependenciesModel, (String)"dependencies(...)");
        DependenciesModel dependencies = dependenciesModel;
        dependencies.addArtifact(configurationName, artifactSpec);
        this.applyChanges(model);
    }

    private final void checkDescriptor(UnifiedDependency descriptor) {
        if (descriptor.getCoordinates().getArtifactId() == null) {
            boolean $i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$52 = false;
            String string = GradleBundle.message((String)"gradle.dsl.artifactid.is.null", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String $i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$52 = string;
            throw new IllegalArgumentException($i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$52.toString());
        }
        if (descriptor.getCoordinates().getGroupId() == null) {
            boolean $i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$62 = false;
            String string = GradleBundle.message((String)"gradle.dsl.groupid.is.null", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String $i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$62 = string;
            throw new IllegalArgumentException($i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$62.toString());
        }
        if (descriptor.getCoordinates().getVersion() == null) {
            boolean $i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$72 = false;
            String string = GradleBundle.message((String)"gradle.dsl.version.is.null", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String $i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$72 = string;
            throw new IllegalArgumentException($i$a$-requireNotNull-GradleDependencyModificator$checkDescriptor$72.toString());
        }
        if (descriptor.getScope() == null) {
            boolean bl = false;
            String string = GradleBundle.message((String)"gradle.dsl.scope.is.null", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final String getConfigurationName(UnifiedDependency descriptor) {
        String string = descriptor.getScope();
        if (string == null) {
            string = "implementation";
        }
        return string;
    }

    public void updateDependency(@NotNull Module module, @NotNull UnifiedDependency oldDescriptor, @NotNull UnifiedDependency newDescriptor) {
        Object v2;
        GradleBuildModel model;
        block7: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)oldDescriptor, (String)"oldDescriptor");
            Intrinsics.checkNotNullParameter((Object)newDescriptor, (String)"newDescriptor");
            this.checkDescriptor(newDescriptor);
            GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
            if (gradleBuildModel == null) {
                this.throwFailToModify(module);
                throw new KotlinNothingValueException();
            }
            model = gradleBuildModel;
            List list = model.dependencies().artifacts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"artifacts(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                ArtifactDependencyModel it = (ArtifactDependencyModel)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.group().valueAsString(), (Object)oldDescriptor.getCoordinates().getGroupId()) && Intrinsics.areEqual((Object)it.name().valueAsString(), (Object)oldDescriptor.getCoordinates().getArtifactId()) && Intrinsics.areEqual((Object)it.version().valueAsString(), (Object)oldDescriptor.getCoordinates().getVersion()) && Intrinsics.areEqual((Object)it.configurationName(), (Object)oldDescriptor.getScope()))) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        ArtifactDependencyModel artifactModel = v2;
        if (artifactModel == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GradleDependencyModificator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to update dependency '" + oldDescriptor + "': not found in module " + module.getName());
            return;
        }
        if (!Intrinsics.areEqual((Object)oldDescriptor.getCoordinates().getGroupId(), (Object)newDescriptor.getCoordinates().getGroupId())) {
            ResolvedPropertyModel resolvedPropertyModel = artifactModel.group();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedPropertyModel, (String)"group(...)");
            String string = newDescriptor.getCoordinates().getGroupId();
            Intrinsics.checkNotNull((Object)string);
            this.updateVariableOrValue(resolvedPropertyModel, string);
        }
        if (!Intrinsics.areEqual((Object)oldDescriptor.getCoordinates().getArtifactId(), (Object)newDescriptor.getCoordinates().getArtifactId())) {
            ResolvedPropertyModel resolvedPropertyModel = artifactModel.name();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedPropertyModel, (String)"name(...)");
            String string = newDescriptor.getCoordinates().getArtifactId();
            Intrinsics.checkNotNull((Object)string);
            this.updateVariableOrValue(resolvedPropertyModel, string);
        }
        if (!Intrinsics.areEqual((Object)oldDescriptor.getCoordinates().getVersion(), (Object)newDescriptor.getCoordinates().getVersion())) {
            ResolvedPropertyModel resolvedPropertyModel = artifactModel.version();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedPropertyModel, (String)"version(...)");
            String string = newDescriptor.getCoordinates().getVersion();
            Intrinsics.checkNotNull((Object)string);
            this.updateVariableOrValue(resolvedPropertyModel, string);
        }
        if (!Intrinsics.areEqual((Object)oldDescriptor.getScope(), (Object)newDescriptor.getScope()) && newDescriptor.getScope() != null) {
            String string = newDescriptor.getScope();
            Intrinsics.checkNotNull((Object)string);
            artifactModel.setConfigurationName(string);
        }
        this.applyChanges(model);
    }

    private final void updateVariableOrValue(ResolvedPropertyModel model, String value) {
        GradlePropertyModel dependencyPropertyModel;
        if (model.getDependencies().size() == 1 && ((dependencyPropertyModel = (GradlePropertyModel)model.getDependencies().get(0)).getPropertyType() == PropertyType.VARIABLE || dependencyPropertyModel.getPropertyType() == PropertyType.REGULAR || dependencyPropertyModel.getPropertyType() == PropertyType.PROPERTIES_FILE) && StringsKt.equals$default((String)dependencyPropertyModel.valueAsString(), (String)model.valueAsString(), (boolean)false, (int)2, null)) {
            dependencyPropertyModel.setValue((Object)value);
            return;
        }
        model.setValue((Object)value);
    }

    public void removeDependency(@NotNull Module module, @NotNull UnifiedDependency descriptor) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.checkDescriptor(descriptor);
        GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
        if (gradleBuildModel == null) {
            this.throwFailToModify(module);
            throw new KotlinNothingValueException();
        }
        GradleBuildModel model = gradleBuildModel;
        DependenciesModel dependenciesModel = model.dependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependenciesModel, (String)"dependencies(...)");
        DependenciesModel dependencies = dependenciesModel;
        for (ArtifactDependencyModel artifactModel : dependencies.artifacts()) {
            if (!Intrinsics.areEqual((Object)artifactModel.group().valueAsString(), (Object)descriptor.getCoordinates().getGroupId()) || !Intrinsics.areEqual((Object)artifactModel.name().valueAsString(), (Object)descriptor.getCoordinates().getArtifactId())) continue;
            String string = artifactModel.version().valueAsString();
            if (string == null) {
                string = "";
            }
            if (!Intrinsics.areEqual((Object)string, (Object)descriptor.getCoordinates().getVersion())) continue;
            dependencies.remove((DependencyModel)artifactModel);
            break;
        }
        this.applyChanges(model);
    }

    public void addRepository(@NotNull Module module, @NotNull UnifiedDependencyRepository repository) {
        String methodName;
        String trimmedUrl;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
        if (gradleBuildModel == null) {
            this.throwFailToModify(module);
            throw new KotlinNothingValueException();
        }
        GradleBuildModel model = gradleBuildModel;
        RepositoriesModel repositoriesModel = model.repositories();
        Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"repositories(...)");
        RepositoriesModel repositoryModel = repositoriesModel;
        String string = repository.getUrl();
        String string2 = trimmedUrl = string != null ? this.trimLastSlash(string) : null;
        if (trimmedUrl == null || repositoryModel.containsMavenRepositoryByUrl(trimmedUrl)) {
            return;
        }
        RepositoriesWithShorthandMethods repositoriesWithShorthandMethods = RepositoriesWithShorthandMethods.Companion.findByUrlLenient(trimmedUrl);
        String string3 = methodName = repositoriesWithShorthandMethods != null ? repositoriesWithShorthandMethods.getMethodName() : null;
        if (methodName != null) {
            if (repositoryModel.containsMethodCall(methodName)) {
                return;
            }
            repositoryModel.addRepositoryByMethodName(methodName);
        } else {
            repositoryModel.addMavenRepositoryByUrl(trimmedUrl, repository.getName());
        }
        this.applyChanges(model);
    }

    public void deleteRepository(@NotNull Module module, @NotNull UnifiedDependencyRepository repository) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
        if (gradleBuildModel == null) {
            this.throwFailToModify(module);
            throw new KotlinNothingValueException();
        }
        GradleBuildModel model = gradleBuildModel;
        RepositoriesModel repositoriesModel = model.repositories();
        Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"repositories(...)");
        RepositoriesModel repositoryModel = repositoriesModel;
        String string = repository.getUrl();
        if (string == null) {
            return;
        }
        String repositoryUrl = string;
        repositoryModel.removeRepositoryByUrl(repositoryUrl);
        repositoryModel.removeRepositoryByUrl(this.trimLastSlash(repositoryUrl));
        this.applyChanges(model);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DeclaredDependency> declaredDependencies(@NotNull Module module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
        if (gradleBuildModel == null) {
            List list;
            List it = list = CollectionsKt.emptyList();
            boolean bl = false;
            this.logMissingModel(module);
            return list;
        }
        GradleBuildModel model = gradleBuildModel;
        List list = model.dependencies().artifacts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"artifacts(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ArtifactDependencyModel artifactDependencyModel = (ArtifactDependencyModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DataContext dataContext = arg_0 -> GradleDependencyModificator.declaredDependencies$lambda$1$0((ArtifactDependencyModel)it2, arg_0);
            collection.add(new DeclaredDependency(it2.group().valueAsString(), it2.name().valueAsString(), it2.version().valueAsString(), it2.configurationName(), dataContext));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<UnifiedDependencyRepository> declaredRepositories(@NotNull Module module) {
        boolean bl;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GradleBuildModel gradleBuildModel = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
        if (gradleBuildModel == null) {
            List list;
            List it = list = CollectionsKt.emptyList();
            boolean bl2 = false;
            this.logMissingModel(module);
            return list;
        }
        GradleBuildModel model = gradleBuildModel;
        List list = model.repositories().repositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"repositories(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UrlBasedRepositoryModelImpl it$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            RepositoryModel it2 = (RepositoryModel)element$iv$iv;
            boolean bl3 = false;
            if ((it2 instanceof UrlBasedRepositoryModelImpl ? (UrlBasedRepositoryModelImpl)it2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnifiedDependencyRepository unifiedDependencyRepository;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            UrlBasedRepositoryModelImpl m = (UrlBasedRepositoryModelImpl)element$iv$iv;
            boolean bl5 = false;
            if (m.url().valueAsString() != null) {
                String it3;
                boolean bl6 = false;
                RepositoryModel.RepositoryType repositoryType = m.getType();
                Intrinsics.checkNotNullExpressionValue((Object)repositoryType, (String)"getType(...)");
                RepositoriesWithShorthandMethods repositoriesWithShorthandMethods = RepositoriesWithShorthandMethods.Companion.findByRepoType(repositoryType);
                unifiedDependencyRepository = new UnifiedDependencyRepository(repositoriesWithShorthandMethods != null ? repositoriesWithShorthandMethods.getRepositoryId() : null, m.name().valueAsString(), it3);
            } else {
                unifiedDependencyRepository = null;
            }
            if (unifiedDependencyRepository == null) continue;
            UnifiedDependencyRepository it$iv$iv = unifiedDependencyRepository;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Void throwFailToModify(Module module) {
        Object[] objectArray = new Object[]{module.getName()};
        throw new IllegalStateException(GradleBundle.message((String)"gradle.dsl.model.fail.to.build", (Object[])objectArray));
    }

    private final void logMissingModel(Module module) {
        Logger $this$debug_u24default$iv = GradleDependencyModificatorKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{module.getName()};
            String string = GradleBundle.message((String)"gradle.dsl.model.fail.to.build", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            logger.debug(string, e$iv);
        }
    }

    private final void applyChanges(GradleBuildModel model) {
        PsiFile[] psiFileArray = new PsiFile[]{model.getPsiFile()};
        WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])psiFileArray).run(() -> GradleDependencyModificator.applyChanges$lambda$0(model));
    }

    private final String trimLastSlash(String $this$trimLastSlash) {
        CharSequence charSequence;
        block2: {
            String $this$trimEnd$iv = $this$trimLastSlash;
            boolean $i$f$trimEnd = false;
            CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
            boolean $i$f$trimEnd2 = false;
            int n = $this$trimEnd$iv$iv.length() + -1;
            if (0 <= n) {
                do {
                    int index$iv$iv = n--;
                    char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (it == '/') continue;
                    charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                    break block2;
                } while (0 <= n);
            }
            charSequence = "";
        }
        return ((Object)charSequence).toString();
    }

    private static final Object declaredDependencies$lambda$1$0(ArtifactDependencyModel $it, String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return CommonDataKeys.PSI_ELEMENT.is(dataId) ? $it.getPsiElement() : null;
    }

    private static final void applyChanges$lambda$0(GradleBuildModel $model) {
        $model.applyChanges();
    }
}

