/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.CSSWriter;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorKit;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.SyntaxPane;
import com.lightdev.app.shtm.Util;
import com.sun.demo.ExampleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

class DocumentPane
extends JPanel
implements DocumentListener,
ChangeListener {
    private final SHTMLEditorPane editorPane;
    private final SyntaxPane sourceEditorPane;
    public Thread saveThread = null;
    public boolean saveSuccessful = false;
    private boolean documentChanged = false;
    private boolean htmlChanged = true;
    private boolean htmlSourceEdited = false;
    private String docName;
    private final JComponent paneHoldingScrollPanes;
    private final JScrollPane richViewScrollPane;
    private final JScrollPane sourceViewScrollPane;
    public static final int VIEW_TAB_LAYOUT = 0;
    public static final int VIEW_TAB_HTML = 1;
    private boolean loadedFromFile = false;
    private String DEFAULT_DOC_NAME = "Untitled";
    public static final String DEFAULT_STYLE_SHEET_NAME = "style.css";
    private int newDocNo;
    private int activeView;
    private final Vector dpListeners = new Vector();
    private File docTempDir;

    private void setDocumentChanged(boolean documentChanged) {
        this.documentChanged = documentChanged;
    }

    private boolean isDocumentChanged() {
        return this.documentChanged;
    }

    private void setHtmlChanged(boolean htmlChanged) {
        this.htmlChanged = htmlChanged;
    }

    private boolean isHtmlChanged() {
        return this.htmlChanged;
    }

    private void setHtmlSourceEdited(boolean htmlSourceEdited) {
        this.htmlSourceEdited = htmlSourceEdited;
    }

    private boolean isHtmlSourceEdited() {
        return this.htmlSourceEdited;
    }

    public DocumentPane() {
        this.editorPane = new SHTMLEditorPane();
        this.richViewScrollPane = new JScrollPane();
        this.richViewScrollPane.getViewport().setView(this.editorPane);
        this.sourceEditorPane = new SyntaxPane();
        this.sourceEditorPane.setFont(new Font("Monospaced", 0, 12));
        this.sourceViewScrollPane = new JScrollPane();
        this.sourceViewScrollPane.getViewport().setView(this.sourceEditorPane);
        if (Util.showViewsInTabs()) {
            this.paneHoldingScrollPanes = new JTabbedPane();
            this.paneHoldingScrollPanes.add((Component)this.richViewScrollPane, 0);
            this.paneHoldingScrollPanes.add((Component)this.sourceViewScrollPane, 1);
            JTabbedPane tabbedPane = (JTabbedPane)this.paneHoldingScrollPanes;
            tabbedPane.setTabPlacement(3);
            tabbedPane.setTitleAt(0, Util.getResourceString("layoutTabTitle"));
            tabbedPane.setTitleAt(1, Util.getResourceString("htmlTabTitle"));
            tabbedPane.addChangeListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.paneHoldingScrollPanes, "Center");
        } else {
            this.paneHoldingScrollPanes = new JPanel(new BorderLayout());
            this.paneHoldingScrollPanes.add((Component)this.richViewScrollPane, "Center");
            this.activeView = 0;
            this.setLayout(new BorderLayout());
            this.add((Component)this.paneHoldingScrollPanes, "Center");
        }
        this.setDocumentChanged(false);
        this.setPreferredSize(new Dimension(550, 550));
    }

    public DocumentPane(URL docToLoad, int newDocNo) {
        this();
        this.DEFAULT_DOC_NAME = Util.getResourceString("defaultDocName");
        if (docToLoad != null) {
            this.loadDocument(docToLoad);
        } else {
            this.newDocNo = newDocNo;
            this.createNewDocument();
        }
    }

    public SHTMLEditorPane getEditor() {
        return this.editorPane;
    }

    public SyntaxPane getHtmlEditor() {
        return this.sourceEditorPane;
    }

    public int getSelectedTab() {
        if (this.paneHoldingScrollPanes instanceof JTabbedPane) {
            return ((JTabbedPane)this.paneHoldingScrollPanes).getSelectedIndex();
        }
        return this.activeView;
    }

    public void createNewDocument() {
        try {
            SHTMLEditorKit kit = (SHTMLEditorKit)this.editorPane.getEditorKit();
            SHTMLDocument doc = (SHTMLDocument)kit.createDefaultDocument();
            doc.addDocumentListener(this);
            this.docTempDir = new File(SHTMLPanelImpl.getAppTempDir().getAbsolutePath() + File.separator + this.getDocumentName() + File.separator);
            URL tempDocumentUrl = new URL(this.docTempDir.toURL(), this.getDocumentName() + ".htm");
            doc.setBase(tempDocumentUrl);
            this.editorPane.setDocument(doc);
            this.updateFileName();
            boolean useStyle = Util.useSteStyleSheet();
            if (useStyle) {
                doc.insertStyleRef();
            }
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
    }

    public void setDocument(Document docToSet) {
        try {
            this.editorPane.getEditorKit();
            SHTMLDocument doc = this.getDocument();
            if (doc != null) {
                doc.removeDocumentListener(this);
            }
            docToSet.addDocumentListener(this);
            this.editorPane.setDocument(docToSet);
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
    }

    public void deleteTempDir() {
        if (this.docTempDir != null) {
            Util.deleteDir(this.docTempDir);
            this.docTempDir = null;
        }
    }

    public void loadDocument(URL url) {
        try {
            SHTMLEditorKit kit = (SHTMLEditorKit)this.editorPane.getEditorKit();
            SHTMLDocument doc = (SHTMLDocument)kit.createDefaultDocument();
            doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            doc.setBase(url);
            try (InputStream in = url.openStream();){
                kit.read(in, (Document)doc, 0);
            }
            doc.addDocumentListener(this);
            this.editorPane.setDocument(doc);
            this.updateFileName();
            this.loadedFromFile = true;
        }
        catch (Exception ex) {
            Util.errMsg(this, "An exception occurred while loading the file", ex);
            ex.printStackTrace();
        }
    }

    private StyleSheet loadStyleSheet(File cssFile) throws MalformedURLException, IOException {
        StyleSheet s = new StyleSheet();
        s.importStyleSheet(cssFile.toURL());
        return s;
    }

    public void saveDocument(URL targetUrl) {
        if (!this.saveInProgress()) {
            this.saveThread = Thread.currentThread();
            this.saveSuccessful = false;
            try {
                if (this.getSelectedTab() == 1) {
                    this.editorPane.setText(this.sourceEditorPane.getText());
                }
                SHTMLDocument doc = this.getDocument();
                try (OutputStream os = Files.newOutputStream(new File(targetUrl.getPath()).toPath(), new OpenOption[0]);
                     OutputStreamWriter osw = new OutputStreamWriter(os);){
                    SHTMLWriter hw = new SHTMLWriter((Writer)osw, doc);
                    hw.write();
                }
                if (doc.hasStyleRef()) {
                    this.saveStyleSheet(targetUrl);
                }
                this.saveImages(targetUrl);
                this.setDocumentChanged(false);
                this.getDocument().setBase(targetUrl);
                this.updateFileName();
                this.deleteTempDir();
                this.saveSuccessful = true;
            }
            catch (Exception e) {
                Util.errMsg(this, "An exception occurred while saving the file", e);
            }
            this.saveThread = null;
        }
    }

    private File getImageDir() {
        return this.getDocument().getImageDirectory();
    }

    private void saveImages(URL targetUrl) {
        File srcDir = this.getImageDir();
        File destDir = SHTMLDocument.getImageDirectory(targetUrl);
        try {
            if (srcDir.exists()) {
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("gif");
                filter.addExtension("jpg");
                filter.addExtension("jpeg");
                File[] imgFiles = srcDir.listFiles();
                for (int i = 0; i < imgFiles.length; ++i) {
                    Util.copyFile(imgFiles[i], new File(destDir.getAbsolutePath() + File.separator + imgFiles[i].getName()));
                }
            }
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
    }

    public boolean saveInProgress() {
        return this.saveThread != null;
    }

    public void saveStyleSheet(URL targetUrl) throws IOException {
        SHTMLDocument doc = this.getDocument();
        StyleSheet styles = doc.getStyleSheet();
        URL styleSheetName = this.getStyleSheetName();
        if (styleSheetName != null) {
            File styleSheetFile = new File(styleSheetName.getFile());
            if (!styleSheetFile.exists()) {
                styleSheetFile.createNewFile();
            } else if (this.loadedFromFile) {
                if (!this.getDocumentUrl().getPath().equals(targetUrl.getPath())) {
                    this.mergeStyleSheets(this.loadStyleSheet(styleSheetFile), styles);
                } else {
                    styleSheetFile.delete();
                    styleSheetFile.createNewFile();
                }
            } else {
                this.mergeStyleSheets(this.loadStyleSheet(styleSheetFile), styles);
            }
            try (OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(styleSheetFile.toPath(), new OpenOption[0]));){
                CSSWriter cssWriter = new CSSWriter(osw, styles);
                cssWriter.write();
            }
        }
    }

    private void mergeStyleSheets(StyleSheet sourceStyleSheet, StyleSheet destinationStyleSheet) throws IOException {
        Vector srcNames = Util.getStyleNames(sourceStyleSheet);
        Vector destNames = Util.getStyleNames(destinationStyleSheet);
        StringWriter sw = new StringWriter();
        StringBuffer buf = sw.getBuffer();
        CSSWriter cssWriter = new CSSWriter(sw, null);
        for (int i = 0; i < srcNames.size(); ++i) {
            Object elem = srcNames.get(i);
            String name = elem.toString();
            if (destNames.contains(elem)) continue;
            buf.delete(0, buf.length());
            cssWriter.writeRule(name, sourceStyleSheet.getStyle(name));
            destinationStyleSheet.removeStyle(name);
            destinationStyleSheet.addRule(buf.toString());
        }
    }

    private URL getStyleSheetName() throws MalformedURLException {
        SHTMLDocument doc = this.getDocument();
        String styleRef = doc.getStyleRef();
        if (styleRef != null) {
            return new URL(doc.getBase(), styleRef);
        }
        return null;
    }

    public String getDocumentName() {
        String theName = this.docName == null || this.docName.isEmpty() ? this.DEFAULT_DOC_NAME + " " + this.newDocNo : this.docName;
        return theName;
    }

    public boolean needsSaving() {
        return this.isDocumentChanged();
    }

    private void updateFileName() {
        String fName = this.getDocumentUrl().getPath();
        this.docName = fName.substring(fName.lastIndexOf("/") + 1);
        this.fireNameChanged();
    }

    public URL getSource() {
        return this.isNewDoc() ? null : this.getDocumentUrl();
    }

    private URL getDocumentUrl() {
        return this.getDocument().getBase();
    }

    public boolean isNewDoc() {
        return this.docTempDir != null;
    }

    public SHTMLDocument getDocument() {
        return this.editorPane.getDocument();
    }

    HTMLDocument getHTMLDocument() {
        return this.getDocument();
    }

    public void switchViews() {
        if (this.paneHoldingScrollPanes instanceof JTabbedPane) {
            return;
        }
        if (this.activeView == 0) {
            this.setHTMLView();
            this.paneHoldingScrollPanes.remove(this.richViewScrollPane);
            this.paneHoldingScrollPanes.add(this.sourceViewScrollPane);
            this.activeView = 1;
        } else {
            this.setLayoutView();
            this.paneHoldingScrollPanes.remove(this.sourceViewScrollPane);
            this.paneHoldingScrollPanes.add(this.richViewScrollPane);
            this.activeView = 0;
        }
    }

    private void setHTMLView() {
        try {
            this.editorPane.getDocument().removeDocumentListener(this);
            StringWriter stringWriter = new StringWriter();
            if (this.isHtmlChanged()) {
                this.editorPane.getEditorKit().write(stringWriter, (Document)this.editorPane.getDocument(), 0, this.editorPane.getDocument().getLength());
                String newText = stringWriter.toString();
                if (!Util.preferenceIsTrue("writeHead", "true")) {
                    newText = newText.replaceAll("(?ims)<head>.*?(<body)", "$1");
                }
                this.sourceEditorPane.setText(newText);
                this.setHtmlChanged(false);
            }
            this.sourceEditorPane.getDocument().addDocumentListener(this);
            this.sourceEditorPane.addCaretListener(this.sourceEditorPane);
            this.setHtmlChanged(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setLayoutView() {
        this.sourceEditorPane.getDocument().removeDocumentListener(this);
        this.sourceEditorPane.removeCaretListener(this.sourceEditorPane);
        if (this.isHtmlSourceEdited()) {
            this.editorPane.setText(this.sourceEditorPane.getText());
            this.setHtmlChanged(false);
            this.setHtmlSourceEdited(false);
        }
        this.editorPane.setCaretPosition(0);
        this.editorPane.getDocument().addDocumentListener(this);
        this.editorPane.requestFocus();
    }

    String getDocumentText() {
        if (this.getSelectedTab() == 1 && this.isHtmlSourceEdited()) {
            this.editorPane.setText(this.sourceEditorPane.getText());
            this.setHtmlSourceEdited(false);
        }
        return this.editorPane.getText();
    }

    void setDocumentText(String sText) {
        switch (this.getSelectedTab()) {
            case 0: {
                this.editorPane.getDocument().removeDocumentListener(this);
                this.editorPane.setText(sText);
                this.editorPane.getDocument().addDocumentListener(this);
                this.setHtmlChanged(true);
                this.setHtmlSourceEdited(false);
                break;
            }
            case 1: {
                this.sourceEditorPane.getDocument().removeDocumentListener(this);
                this.sourceEditorPane.setText(sText);
                this.sourceEditorPane.getDocument().addDocumentListener(this);
                this.setHtmlChanged(false);
                this.setHtmlSourceEdited(true);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DocumentPane.this.setDocumentChanged(false);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src.equals(this.paneHoldingScrollPanes)) {
            switch (this.getSelectedTab()) {
                case 0: {
                    this.setLayoutView();
                    break;
                }
                case 1: {
                    this.setHTMLView();
                }
            }
        }
        SHTMLPanelImpl.getOwnerSHTMLPanel(this).updateActions();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setDocumentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setDocumentChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.getSelectedTab() == 0) {
            this.editorPane.updateInputAttributes();
            this.setDocumentChanged();
        }
    }

    private void setDocumentChanged() {
        if (this.getSelectedTab() == 0) {
            this.setHtmlChanged(true);
        } else if (this.getSelectedTab() == 1) {
            this.setHtmlSourceEdited(true);
        }
        this.setDocumentChanged(true);
    }

    public void addDocumentPaneListener(DocumentPaneListener listener) {
        if (!this.dpListeners.contains(listener)) {
            this.dpListeners.addElement(listener);
        }
    }

    public void removeDocumentPaneListener(DocumentPaneListener listener) {
        this.dpListeners.remove(listener);
    }

    public void fireNameChanged() {
        Enumeration listenerList = this.dpListeners.elements();
        while (listenerList.hasMoreElements()) {
            ((DocumentPaneListener)listenerList.nextElement()).nameChanged(new DocumentPaneEvent(this));
        }
    }

    public void fireActivated() {
        Enumeration listenerList = this.dpListeners.elements();
        while (listenerList.hasMoreElements()) {
            ((DocumentPaneListener)listenerList.nextElement()).activated(new DocumentPaneEvent(this));
        }
    }

    public void removeAllListeners() {
        this.dpListeners.clear();
    }

    public JEditorPane getMostRecentFocusOwner() {
        switch (this.getSelectedTab()) {
            case 0: {
                return this.editorPane;
            }
            case 1: {
                return this.sourceEditorPane;
            }
        }
        return null;
    }

    public void setContentPanePreferredSize(Dimension prefSize) {
        this.setPreferredSize(null);
        this.paneHoldingScrollPanes.setPreferredSize(null);
        for (int i = 0; i < this.paneHoldingScrollPanes.getComponentCount(); ++i) {
            JScrollPane scrollPane = (JScrollPane)this.paneHoldingScrollPanes.getComponent(i);
            scrollPane.setPreferredSize(prefSize);
            scrollPane.invalidate();
        }
    }

    public static interface DocumentPaneListener {
        public void nameChanged(DocumentPaneEvent var1);

        public void activated(DocumentPaneEvent var1);
    }

    static class DocumentPaneEvent
    extends EventObject {
        public DocumentPaneEvent(Object source) {
            super(source);
        }
    }
}

