'''OpenGL extension OES.vertex_half_float

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.vertex_half_float to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds a 16-bit floating pt data type (aka half float) 
	to vertex data specified using vertex arrays.  The 16-bit floating-point
	components have 1 sign bit, 5 exponent bits, and 10 mantissa bits.
	
	The half float data type can be very useful in specifying vertex attribute 
	data such as color, normals, texture coordinates etc.  By using half floats 
	instead of floats, we reduce the memory requirements by half.  Not only does 
	the memory footprint reduce by half, but the memory bandwidth required for
	vertex transformations also reduces by the same amount approximately.
	Another advantage of using half floats over short/byte data types is that we 
	do not needto scale the data.  For example, using SHORT for texture coordinates 
	implies that we need to scale the input texture coordinates in the shader or 
	set an appropriate scale matrix as the texture matrix for fixed function pipeline.
	Doing these additional scaling operations impacts vertex transformation
	performance.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/vertex_half_float.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.vertex_half_float import *
from OpenGL.raw.GLES2.OES.vertex_half_float import _EXTENSION_NAME

def glInitVertexHalfFloatOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION