/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.PatchedRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LazyPatchContentRevision
implements ContentRevision {
    private final VirtualFile myVf;
    private final FilePath myNewFilePath;
    @NotNull
    private final PatchedRevisionNumber myRevision;
    private final TextFilePatch myPatch;
    private final Supplier<Data> myData;

    public LazyPatchContentRevision(VirtualFile vf, FilePath newFilePath, @NotNull PatchedRevisionNumber revision, TextFilePatch patch) {
        if (revision == null) {
            LazyPatchContentRevision.$$$reportNull$$$0(0);
        }
        this.myData = new SynchronizedClearableLazy(this::loadContent);
        this.myVf = vf;
        this.myNewFilePath = newFilePath;
        this.myRevision = revision;
        this.myPatch = patch;
    }

    private Data loadContent() {
        String localContext = (String)ReadAction.compute(() -> {
            Document doc = FileDocumentManager.getInstance().getDocument(this.myVf);
            return doc == null ? null : doc.getText();
        });
        if (localContext == null) {
            return new Data(null, true);
        }
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(localContext, this.myPatch.getHunks());
        if (appliedPatch != null) {
            return new Data(appliedPatch.patchedText, false);
        }
        return new Data(null, true);
    }

    @Nullable
    public String getContent() {
        return this.myData.get().content;
    }

    public boolean isPatchApplyFailed() {
        return this.myData.get().patchApplyFailed;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myNewFilePath;
        if (filePath == null) {
            LazyPatchContentRevision.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        PatchedRevisionNumber patchedRevisionNumber = this.myRevision;
        if (patchedRevisionNumber == null) {
            LazyPatchContentRevision.$$$reportNull$$$0(2);
        }
        return patchedRevisionNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/LazyPatchContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/LazyPatchContentRevision";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class Data {
        @Nullable
        public final String content;
        public final boolean patchApplyFailed;

        Data(@Nullable String content, boolean patchApplyFailed) {
            this.content = content;
            this.patchApplyFailed = patchApplyFailed;
        }
    }
}

