/**
 * @param {Root} tree
 *   Tree.
 * @param {VFile} file
 *   File.
 * @param {Readonly<Options> | null | undefined} [options]
 *   Configuration (optional).
 * @returns
 *   Compiler.
 */
export function toRoff(tree: Root, file: VFile, options?: Readonly<Options> | null | undefined): string;
export type Heading = import('mdast').Heading;
export type Parents = import('mdast').Parents;
export type PhrasingContent = import('mdast').PhrasingContent;
export type Root = import('mdast').Root;
export type TableCell = import('mdast').TableCell;
export type TableRow = import('mdast').TableRow;
export type GetDefinition = import('mdast-util-definitions').GetDefinition;
export type UnistNode = import('unist').Node;
export type VFile = import('vfile').VFile;
export type FlowParents = Exclude<Parents, PhrasingContent | TableCell | TableRow>;
export type PhrasingParents = import("mdast").Blockquote | import("mdast").Heading | import("mdast").List | import("mdast").Paragraph | import("mdast").Table | import("mdast").FootnoteDefinition | import("mdast").ListItem | import("mdast").Delete | import("mdast").Emphasis | import("mdast").Link | import("mdast").LinkReference | import("mdast").Strong | import("mdast").TableCell | import("mdast").TableRow | import("mdast").Root;
/**
 * Handle a parent.
 */
export type ContainerFlow = (node: FlowParents) => string;
/**
 * Handle a parent.
 */
export type ContainerPhrasing = (node: PhrasingParents) => string;
/**
 * Handle a particular node.
 */
export type Handle = (node: any, state: State) => string | undefined;
/**
 * Configuration.
 */
export type Options = {
    /**
     * Date of page (default: `new Date()`);
     * given to `new Date(x)`;
     * dates are centered in the footer line of the displayed page.
     */
    date?: Readonly<Date> | number | string | null | undefined;
    /**
     * Description of page (optional);
     * inferred from the main heading: `# hello-world(7) -- Two common words`
     * defaults to `'Two common words'`.
     */
    description?: string | null | undefined;
    /**
     * Manual of page (optional);
     * manuals are centered in the header line of the displayed page.
     */
    manual?: string | null | undefined;
    /**
     * Title of the page (optional);
     * inferried from the main heading (`# hello-world(7)` defaults to
     * `'hello-world'`) or the file name (`hello-world.1.md` defaults to
     * `'hello-world'`).
     */
    name?: string | null | undefined;
    /**
     * Manual section of page (optional);
     * inferred from the main heading (`# hello-world(7)` defaults to `7`) or the
     * file name (`hello-world.1.md` defaults to `1`).
     */
    section?: number | string | null | undefined;
    /**
     * Version of page;
     * versions are positioned at the left of the footer line of the displayed
     * page.
     */
    version?: string | null | undefined;
};
/**
 * Info passed around.
 */
export type State = {
    /**
     *   Serialize children in a flow parent.
     */
    containerFlow: ContainerFlow;
    /**
     *   Serialize children in a phrasing parent.
     */
    containerPhrasing: ContainerPhrasing;
    /**
     *   Get a definition.
     */
    definitions: GetDefinition;
    /**
     *   Headings by GH slug.
     */
    headings: Map<string, Heading>;
    /**
     *   Whether to act as if one extra heading depth is used.
     */
    increaseDepth: boolean;
    /**
     *   Current indent level.
     */
    level: number;
    /**
     *   Primary heading.
     */
    mainHeading: Heading | undefined;
    /**
     *   Current text style stack.
     */
    textStyle: Array<TextStyle>;
};
/**
 * Text style.
 */
export type TextStyle = 'B' | 'I' | 'R';
