/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffprobe.PacketFrameSubtitle;
import com.github.kokorin.jaffree.ffprobe.SideData;
import com.github.kokorin.jaffree.ffprobe.TagAware;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import java.util.List;

public class Packet
implements TagAware,
PacketFrameSubtitle {
    private final ProbeData probeData;

    public Packet(ProbeData probeData) {
        this.probeData = probeData;
    }

    @Override
    public ProbeData getProbeData() {
        return this.probeData;
    }

    public Long getPts() {
        return this.probeData.getLong("pts");
    }

    public Float getPtsTime() {
        return this.probeData.getFloat("pts_time");
    }

    public List<SideData> getSideDataList() {
        return this.probeData.getSubDataList("side_data_list", SideData::new);
    }

    public StreamType getCodecType() {
        return this.probeData.getStreamType("codec_type");
    }

    public Integer getStreamIndex() {
        return this.probeData.getInteger("stream_index");
    }

    public Long getDts() {
        return this.probeData.getLong("dts");
    }

    public Float getDtsTime() {
        return this.probeData.getFloat("dts_time");
    }

    public Long getDuration() {
        return this.probeData.getLong("duration");
    }

    public Float getDurationTime() {
        return this.probeData.getFloat("duration_time");
    }

    public Long getConvergenceDuration() {
        return this.probeData.getLong("convergence_duration");
    }

    public Float getConvergenceDurationTime() {
        return this.probeData.getFloat("convergence_duration_time");
    }

    public Long getSize() {
        return this.probeData.getLong("size");
    }

    public Long getPos() {
        return this.probeData.getLong("pos");
    }

    public String getFlags() {
        return this.probeData.getString("flags");
    }

    public String getData() {
        return this.probeData.getString("data");
    }

    public String getDataHash() {
        return this.probeData.getString("data_hash");
    }
}

