/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.api;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.keycloak.admin.api.AdminApi;
import org.keycloak.admin.api.DefaultAdminApi;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resources.admin.AdminCorsPreflightService;

@Provider
@Path(value="admin/api")
public class AdminRootV2 {
    @Context
    protected KeycloakSession session;

    @Path(value="v2")
    public AdminApi adminApi() {
        this.checkApiEnabled();
        return new DefaultAdminApi(this.session);
    }

    @Path(value="{any:.*}")
    @OPTIONS
    @Operation(hidden=true)
    public Object preFlight() {
        this.checkApiEnabled();
        return new AdminCorsPreflightService();
    }

    private void checkApiEnabled() {
        if (!AdminRootV2.isAdminApiV2Enabled()) {
            throw new NotFoundException();
        }
    }

    public static boolean isAdminApiV2Enabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_ADMIN_API_V2);
    }
}

