/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.remover.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.QueryBasedConditionalRemover;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ByRealmIdQueryConditionalRemover<K, V extends SessionEntity>
extends QueryBasedConditionalRemover<K, V> {
    private static final String CONDITION_FMT = "realmId IN (%s)";
    private final String entity;
    private final List<String> realms;

    public ByRealmIdQueryConditionalRemover(String entity) {
        this.entity = entity;
        this.realms = new ArrayList<String>();
    }

    private static String parameter(int index) {
        return "p" + index;
    }

    public void removeByRealmId(String realmId) {
        this.realms.add(realmId);
    }

    @Override
    String getEntity() {
        return this.entity;
    }

    @Override
    String getQueryConditions() {
        assert (!this.isEmpty());
        String condition = IntStream.range(0, this.realms.size()).mapToObj(value -> ":" + ByRealmIdQueryConditionalRemover.parameter(value)).collect(Collectors.joining(", "));
        return CONDITION_FMT.formatted(condition);
    }

    @Override
    Map<String, Object> getQueryParameters() {
        assert (!this.isEmpty());
        HashMap<String, Object> params = new HashMap<String, Object>();
        int paramIdx = 0;
        for (String realmId : this.realms) {
            params.put(ByRealmIdQueryConditionalRemover.parameter(paramIdx++), realmId);
        }
        return params;
    }

    @Override
    boolean isEmpty() {
        return this.realms.isEmpty();
    }

    @Override
    public boolean willRemove(K key, V value) {
        return value != null && this.realms.contains(((SessionEntity)value).getRealmId());
    }
}

