/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.Optional;

public final class LongConst
extends ConstImpl {
    private final Long value;

    public LongConst(Long value) {
        super(ConstantDescs.CD_long);
        this.value = value;
    }

    public LongConst(ConstantDesc constantDesc) {
        this((Long)constantDesc);
    }

    public long longValue() {
        return this.value;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        long unboxed = this.value;
        if (-32768L <= unboxed && unboxed <= 32767L) {
            int asInt = (int)unboxed;
            switch (asInt) {
                case -5: {
                    cb.iconst_5();
                    cb.ineg();
                    cb.i2l();
                    break;
                }
                case -4: {
                    cb.iconst_4();
                    cb.ineg();
                    cb.i2l();
                    break;
                }
                case -3: {
                    cb.iconst_3();
                    cb.ineg();
                    cb.i2l();
                    break;
                }
                case -2: {
                    cb.iconst_2();
                    cb.ineg();
                    cb.i2l();
                    break;
                }
                case -1: {
                    cb.iconst_m1();
                    cb.i2l();
                    break;
                }
                case 0: {
                    cb.lconst_0();
                    break;
                }
                case 1: {
                    cb.lconst_1();
                    break;
                }
                case 2: {
                    cb.iconst_2();
                    cb.i2l();
                    break;
                }
                case 3: {
                    cb.iconst_3();
                    cb.i2l();
                    break;
                }
                case 4: {
                    cb.iconst_4();
                    cb.i2l();
                    break;
                }
                case 5: {
                    cb.iconst_5();
                    cb.i2l();
                    break;
                }
                default: {
                    if (-128L <= unboxed && unboxed <= 127L) {
                        cb.bipush(asInt);
                    } else {
                        cb.sipush(asInt);
                    }
                    cb.i2l();
                    break;
                }
            }
        } else {
            cb.ldc((ConstantDesc)Long.valueOf(unboxed));
        }
    }

    @Override
    public boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public boolean isNonZero() {
        return this.value != 0L;
    }

    @Override
    public boolean equals(ConstImpl obj) {
        LongConst other;
        return obj instanceof LongConst && this.equals(other = (LongConst)obj);
    }

    public boolean equals(LongConst other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public ConstantDesc desc() {
        return this.value;
    }

    public Optional<Long> describeConstable() {
        return Optional.of(this.value);
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        return b.append(this.value).append("L (0x").append(Long.toHexString(this.value)).append("L)");
    }
}

