/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Cursor;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.jmol.dialog.Dialog;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jsonkiosk.KioskFrame;

public class Jmol
extends JmolPanel {
    static boolean isSwingJS = false;

    public Jmol(JmolApp jmolApp, Splash splash, JFrame frame, Jmol parent, int startupWidth, int startupHeight, Map<String, Object> vwrOptions, Point loc) {
        super(jmolApp, splash, frame, parent, startupWidth, startupHeight, vwrOptions, loc);
    }

    public static void main(String[] args) {
        Jmol.startJmol(new JmolApp(args));
    }

    protected static void startJmol(JmolApp jmolApp) {
        block12: {
            JFrame jmolFrame;
            Dialog.setupUIManager();
            if (jmolApp.isKiosk) {
                if (jmolApp.startupWidth < 100 || jmolApp.startupHeight < 100) {
                    jmolApp.startupWidth = Jmol.screenSize.width;
                    jmolApp.startupHeight = Jmol.screenSize.height - 75;
                }
                kioskFrame = new KioskFrame(0, 75, jmolApp.startupWidth, jmolApp.startupHeight, null);
                jmolFrame = kioskFrame;
            } else {
                jmolFrame = new JFrame();
            }
            Jmol jmol = null;
            try {
                if (jmolApp.jmolPosition != null) {
                    jmolFrame.setLocation(jmolApp.jmolPosition);
                }
                jmol = Jmol.getJmol(jmolApp, jmolFrame);
                jmolApp.startViewer(jmol.vwr, jmol.splash, false);
            }
            catch (Throwable t) {
                Logger.error("uncaught exception: " + t);
                t.printStackTrace();
            }
            if (jmolApp.haveJavaConsole && allowJavaConsole) {
                jmol.getJavaConsole();
            }
            if (jmolApp.isKiosk) {
                kioskFrame.setPanel(jmol);
                bannerFrame.setLabel("click below and type exitJmol[enter] to quit");
                jmol.vwr.script("set allowKeyStrokes;set zoomLarge false;");
            }
            if (jmolApp.port > 0) {
                try {
                    jmol.clientService = Jmol.getJsonNioServer();
                    jmol.clientService.startService(jmolApp.port, jmol, jmol.vwr, "-1", 1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (bannerFrame != null) {
                        bannerFrame.setLabel("could not start NIO service on port " + jmolApp.port);
                    }
                    if (jmol.clientService == null) break block12;
                    jmol.clientService.close();
                }
            }
        }
    }

    public static Jmol getJmol(JFrame baseframe, int width, int height, Map<String, Object> vwrOptions) {
        JmolApp jmolApp = new JmolApp(new String[0]);
        jmolApp.startupHeight = height;
        jmolApp.startupWidth = width;
        jmolApp.info = vwrOptions == null ? new Hashtable() : vwrOptions;
        return Jmol.getJmol(jmolApp, baseframe);
    }

    public static Jmol getJmol(JmolApp jmolApp, JFrame frame) {
        Splash splash = null;
        if (jmolApp.haveDisplay && jmolApp.splashEnabled) {
            ImageIcon splash_image = JmolResourceHandler.getIconX("splash");
            if (!jmolApp.isSilent) {
                Logger.info("splash_image=" + splash_image);
            }
            splash = new Splash(frame, splash_image);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT.$("Creating main window..."));
            splash.showStatus(GT.$("Initializing Swing..."));
        }
        if (jmolApp.haveDisplay) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exc) {
                System.err.println("Error loading L&F: " + exc);
            }
        }
        if (splash != null) {
            splash.showStatus(GT.$("Initializing Jmol..."));
        }
        Jmol window = new Jmol(jmolApp, splash, frame, null, jmolApp.startupWidth, jmolApp.startupHeight, jmolApp.info, null);
        if (jmolApp.haveDisplay) {
            frame.setVisible(true);
        }
        return window;
    }
}

