/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.dev.psiViewer.PsiViewerDialog;
import com.intellij.dev.psiViewer.ViewerPsiBasedTree;
import com.intellij.dev.psiViewer.formatter.BlockTreeNode;
import com.intellij.dev.psiViewer.formatter.BlockTreeStructure;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockViewerPsiBasedTree
implements ViewerPsiBasedTree {
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final Tree myBlockTree;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewerPsiBasedTree.PsiTreeUpdater myUpdater;
    @Nullable
    private volatile HashMap<PsiElement, BlockTreeNode> myPsiToBlockMap;
    private AsyncTreeModel myTreeModel;
    private Disposable myTreeModelDisposable;

    public BlockViewerPsiBasedTree(@NotNull Project project, @NotNull ViewerPsiBasedTree.PsiTreeUpdater updater) {
        if (project == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(0);
        }
        if (updater == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(1);
        }
        this.myTreeModelDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myUpdater = updater;
        this.myBlockTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)this.myBlockTree, (boolean)true);
        PsiViewerDialog.initTree((JTree)this.myBlockTree);
    }

    @Override
    public void reloadTree(@Nullable PsiElement rootRootElement, @NotNull String text) {
        if (text == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(2);
        }
        this.resetBlockTree();
        this.buildBlockTree(rootRootElement);
    }

    @Override
    public void selectNodeFromPsi(@Nullable PsiElement element) {
        BlockTreeNode currentBlockNode;
        if (this.myTreeModel != null && element != null && (currentBlockNode = this.findBlockNode(element)) != null) {
            this.selectBlockNode(currentBlockNode);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    public boolean isFocusOwner() {
        return this.myBlockTree.isFocusOwner();
    }

    @Override
    public void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myBlockTree, true);
    }

    public void dispose() {
        this.resetBlockTree();
    }

    private void resetBlockTree() {
        this.myBlockTree.removeAll();
        if (this.myTreeModel != null) {
            Disposer.dispose((Disposable)this.myTreeModelDisposable);
            this.myTreeModel = null;
            this.myTreeModelDisposable = Disposer.newDisposable();
        }
        this.myPsiToBlockMap = null;
        ViewerPsiBasedTree.removeListenerOfClass(this.myBlockTree, BlockTreeSelectionListener.class);
    }

    private void buildBlockTree(@Nullable PsiElement rootElement) {
        Block rootBlock;
        Block block = rootBlock = rootElement == null ? null : BlockViewerPsiBasedTree.buildBlocks(rootElement);
        if (rootBlock == null) {
            this.myTreeModel = null;
            this.myBlockTree.setRootVisible(false);
            this.myBlockTree.setVisible(false);
            return;
        }
        this.myBlockTree.setVisible(true);
        BlockTreeStructure blockTreeStructure = new BlockTreeStructure();
        BlockTreeNode rootNode = new BlockTreeNode(rootBlock, null);
        StructureTreeModel treeModel = new StructureTreeModel((AbstractTreeStructure)blockTreeStructure, this.myTreeModelDisposable);
        this.initMap(rootNode, rootElement);
        PsiElement rootPsi = rootNode.getBlock() instanceof ASTBlock ? ((ASTBlock)rootNode.getBlock()).getNode().getPsi() : rootElement;
        BlockTreeNode blockNode = Objects.requireNonNull(this.myPsiToBlockMap).get(rootPsi);
        if (blockNode == null) {
            PsiViewerDialog.LOG.error("PsiViewer: rootNode not found\nCurrent language: " + String.valueOf(rootElement.getContainingFile().getLanguage()), (Throwable)null, new Attachment[]{CoreAttachmentFactory.createAttachment((VirtualFile)rootElement.getContainingFile().getOriginalFile().getVirtualFile())});
            blockNode = this.findBlockNode(rootPsi);
        }
        blockTreeStructure.setRoot(blockNode);
        this.myTreeModel = new AsyncTreeModel((TreeModel)treeModel, this.myTreeModelDisposable);
        this.myBlockTree.setModel((TreeModel)this.myTreeModel);
        this.myBlockTree.addTreeSelectionListener((TreeSelectionListener)new BlockTreeSelectionListener(rootElement));
        this.myBlockTree.setRootVisible(true);
        this.myBlockTree.expandRow(0);
        treeModel.invalidateAsync();
    }

    @Nullable
    private BlockTreeNode findBlockNode(PsiElement element) {
        BlockTreeNode result;
        HashMap<PsiElement, BlockTreeNode> psiToBlockMap = this.myPsiToBlockMap;
        BlockTreeNode blockTreeNode = result = psiToBlockMap == null ? null : psiToBlockMap.get(element);
        if (result == null) {
            TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, element.getTextRange());
            result = this.findBlockNode(rangeInHostFile);
        }
        return result;
    }

    @NotNull
    private TreeVisitor createVisitor(@NotNull BlockTreeNode currentBlockNode) {
        if (currentBlockNode == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(4);
        }
        Function converter = el -> el instanceof DefaultMutableTreeNode ? (BlockTreeNode)((Object)((Object)((DefaultMutableTreeNode)el).getUserObject())) : null;
        final HashSet<SimpleNode> parents = new HashSet<SimpleNode>();
        for (SimpleNode parent = currentBlockNode.getParent(); parent != null; parent = parent.getParent()) {
            parents.add(parent);
        }
        DefaultMutableTreeNode root = this.getRoot();
        if (root != null) {
            parents.add((SimpleNode)root.getUserObject());
        }
        return new TreeVisitor.ByComponent<BlockTreeNode, BlockTreeNode>(currentBlockNode, converter){

            protected boolean contains(@NotNull BlockTreeNode pathComponent, @NotNull BlockTreeNode thisComponent) {
                if (pathComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (thisComponent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return parents.contains((Object)pathComponent);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pathComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "thisComponent";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/dev/psiViewer/formatter/BlockViewerPsiBasedTree$1";
                objectArray[2] = "contains";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void selectBlockNode(@Nullable BlockTreeNode currentBlockNode) {
        if (this.myTreeModel == null) {
            return;
        }
        if (currentBlockNode != null) {
            TreeUtil.promiseSelect((JTree)this.myBlockTree, (TreeVisitor)this.createVisitor(currentBlockNode));
        } else {
            this.myBlockTree.getSelectionModel().clearSelection();
        }
    }

    @Nullable
    private BlockTreeNode findBlockNode(TextRange range) {
        if (this.myTreeModel == null || !this.myComponent.isVisible()) {
            return null;
        }
        DefaultMutableTreeNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        BlockTreeNode node = (BlockTreeNode)((Object)root.getUserObject());
        block0: while (true) {
            if (node.getBlock().getTextRange().equals((Object)range)) {
                return node;
            }
            for (BlockTreeNode child : node.getChildren()) {
                if (!child.getBlock().getTextRange().contains(range)) continue;
                node = child;
                continue block0;
            }
            break;
        }
        return node;
    }

    @Nullable
    private static Block buildBlocks(@NotNull PsiElement rootElement) {
        if (rootElement == null) {
            BlockViewerPsiBasedTree.$$$reportNull$$$0(5);
        }
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext(rootElement);
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)rootElement.getContainingFile());
        if (formattingModelBuilder != null) {
            FormattingModel formattingModel = formattingModelBuilder.createModel(FormattingContext.create((PsiElement)rootElement, (CodeStyleSettings)settings));
            return formattingModel.getRootBlock();
        }
        return null;
    }

    private void initMap(BlockTreeNode rootBlockNode, PsiElement psiEl) {
        HashMap<PsiElement, BlockTreeNode> psiToBlockMap = new HashMap<PsiElement, BlockTreeNode>();
        JBTreeTraverser traverser = JBTreeTraverser.of(BlockTreeNode::getChildren);
        for (BlockTreeNode block : (JBTreeTraverser)traverser.withRoot((Object)rootBlockNode)) {
            ASTNode node;
            PsiElement currentElem = null;
            if (block.getBlock() instanceof ASTBlock && (node = ((ASTBlock)block.getBlock()).getNode()) != null) {
                currentElem = node.getPsi();
            }
            if (currentElem == null) {
                currentElem = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)psiEl.getContainingFile(), (int)block.getBlock().getTextRange().getStartOffset());
            }
            psiToBlockMap.put(currentElem, block);
            TextRange curTextRange = currentElem.getTextRange();
            for (PsiElement parentElem = currentElem.getParent(); parentElem != null && parentElem.getTextRange() != null && parentElem.getTextRange().equals((Object)curTextRange); parentElem = parentElem.getParent()) {
                psiToBlockMap.put(parentElem, block);
            }
        }
        this.myPsiToBlockMap = psiToBlockMap;
    }

    @Nullable
    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.myBlockTree.getModel().getRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dev/psiViewer/formatter/BlockViewerPsiBasedTree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBlockNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dev/psiViewer/formatter/BlockViewerPsiBasedTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reloadTree";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildBlocks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public class BlockTreeSelectionListener
    implements TreeSelectionListener {
        @NotNull
        private final PsiElement myRootElement;

        public BlockTreeSelectionListener(PsiElement rootElement) {
            if (rootElement == null) {
                BlockTreeSelectionListener.$$$reportNull$$$0(0);
            }
            this.myRootElement = rootElement;
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                BlockTreeSelectionListener.$$$reportNull$$$0(1);
            }
            if (BlockViewerPsiBasedTree.this.myTreeModel == null) {
                return;
            }
            TreePath path = BlockViewerPsiBasedTree.this.myBlockTree.getSelectionModel().getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode component = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (component == null) {
                return;
            }
            Object item = component.getUserObject();
            if (!(item instanceof BlockTreeNode)) {
                return;
            }
            BlockTreeNode descriptor = (BlockTreeNode)((Object)item);
            int blockStart = descriptor.getBlock().getTextRange().getStartOffset();
            PsiFile file = this.myRootElement.getContainingFile();
            PsiElement currentPsiEl = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)blockStart);
            if (currentPsiEl == null) {
                currentPsiEl = file;
            }
            int blockLength = descriptor.getBlock().getTextRange().getLength();
            while (currentPsiEl.getParent() != null && currentPsiEl.getTextRange().getStartOffset() == blockStart && currentPsiEl.getTextLength() != blockLength) {
                currentPsiEl = currentPsiEl.getParent();
            }
            BlockTreeNode rootBlockNode = (BlockTreeNode)((Object)BlockViewerPsiBasedTree.this.getRoot().getUserObject());
            int baseOffset = 0;
            if (rootBlockNode != null) {
                baseOffset = rootBlockNode.getBlock().getTextRange().getStartOffset();
            }
            TextRange range = descriptor.getBlock().getTextRange();
            range = range.shiftRight(-baseOffset);
            BlockViewerPsiBasedTree.this.myUpdater.updatePsiTree(currentPsiEl, (TextRange)(BlockViewerPsiBasedTree.this.myBlockTree.hasFocus() ? range : null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dev/psiViewer/formatter/BlockViewerPsiBasedTree$BlockTreeSelectionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

