---
stage: Data Access
group: Gitaly
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ハウスキーピング
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabは、Gitリポジトリのハウスキーピングタスクをサポートおよび自動化し、可能な限り効率的に提供できるようにします。ハウスキーピングタスクには、次のものがあります:

- Gitオブジェクトとリビジョンの圧縮。
- 到達不能オブジェクトの削除。
- ロックファイルなどの古いデータの削除。
- パフォーマンスを向上させるデータ構造の維持。
- オブジェクトプールを更新して、フォーク間のオブジェクト重複排除を改善します。

{{< alert type="warning" >}}

GitLabが制御するGitリポジトリで、ハウスキーピングを実行するために、Gitコマンドを手動で実行しないでください。そうすると、リポジトリが破損し、データが失われる可能性があります。

{{< /alert >}}

## ハウスキーピング戦略 {#housekeeping-strategy}

Gitalyは、Gitリポジトリでハウスキーピングタスクを2つの方法で実行できます:

- [Eagerハウスキーピング](#eager-housekeeping)は、リポジトリの状態に関係なく、特定のハウスキーピングタスクを実行します。
- [ヒューリスティックハウスキーピング](#heuristical-housekeeping)は、リポジトリの状態に基づいて実行する必要があるハウスキーピングタスクを決定する一連のヒューリスティックに基づいて、ハウスキーピングタスクを実行します。

### Eagerハウスキーピング {#eager-housekeeping}

「Eager」ハウスキーピング戦略は、リポジトリの状態に関係なく、リポジトリでハウスキーピングタスクを実行します。これは、[手動トリガー](#manual-trigger)とプッシュベースのトリガーで使用されるデフォルトの戦略です。

Eagerハウスキーピング戦略は、GitLabアプリケーションによって制御されます。ハウスキーピングジョブの実行をトリガーした内容に応じて、GitLabはGitalyに特定のハウスキーピングタスクを実行するように要求します。Gitalyは、リポジトリが最適化された状態にある場合でも、これらのタスクを実行します。その結果、この戦略は、ハウスキーピングタスクの実行が遅くなる可能性のある大規模なリポジトリでは非効率になる可能性があります。

### ヒューリスティックハウスキーピング {#heuristical-housekeeping}

{{< history >}}

- [導入](https://gitlab.com/gitlab-org/gitaly/-/issues/2634) ：GitLab 14.9、[手動トリガー](#manual-trigger)、`optimized_housekeeping`という名前の[フラグ付き](feature_flags/_index.md)のプッシュベーストリガー。デフォルトでは有効になっています。
- GitLab 14.10で[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/353607)で有効になりました。
- GitLab 15.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107661)になりました。機能フラグ`optimized_housekeeping`は削除されました。

{{< /history >}}

ヒューリスティック（または「機会的」）ハウスキーピング戦略は、リポジトリの状態を分析し、1つ以上のデータ構造が十分に最適化されていないことが判明した場合にのみ、ハウスキーピングタスクを実行します。これは、[スケジュールされたハウスキーピング](#scheduled-housekeeping)で使用される戦略です。

ヒューリスティックハウスキーピングは、実行する必要のあるタスクを決定するために、次の情報を使用します:

- ルーズオブジェクトと古いオブジェクトの数。
- すでに圧縮されたオブジェクトを含むパックファイルの数。
- ルーズな参照の数。
- コミットグラフの存在。

分析されたデータ構造を最適化する必要があるかどうかは、リポジトリのサイズに基づいています:

- オブジェクトは、すべてのオブジェクトの合計サイズが大きいほど、頻繁に再パックされます。
- 参照は、合計参照が多いほど、再パックされる頻度が少なくなります。

Gitalyは、これらのデータ構造を最適化すると、大きくなるほど時間がかかるという事実を相殺するために、これを行います。大規模なモノリポジトリ（大量のトラフィックを受信する）では、最適化を頻繁に行わないようにすることが特に重要です。

Gitalyにリポジトリの最適化を依頼する頻度を変更できます。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **リポジトリ**を選択します。
1. **リポジトリの保守**を展開します。
1. **ハウスキーピング**ハウスキーピングセクションで、ハウスキーピングオプションを設定します。
1. **変更を保存**を選択します。

- **自動リポジトリハウスキーピングを有効にする**: リポジトリの最適化を実行するようにGitalyに定期的に依頼します。この設定を長時間無効にしたままにすると、GitLabサーバー上のGitリポジトリへのアクセスが遅くなり、リポジトリがより多くのディスク領域を使用するようになります。
- **リポジトリの期間を最適化**: Gitalyにリポジトリの最適化を依頼するまでのGitプッシュの数。

## ハウスキーピングタスクの実行 {#running-housekeeping-tasks}

GitLabがハウスキーピングタスクを実行する方法はいくつかあります:

- プロジェクトの管理者は、[手動でリポジトリハウスキーピングタスクをトリガーできます](#manual-trigger)。
- GitLabは、Gitプッシュの数に基づいて、ハウスキーピングタスクを自動的にスケジュールできます。
- GitLabは、構成可能な時間枠で、すべてのリポジトリに対してハウスキーピングタスクを実行する[ジョブをスケジュール](#scheduled-housekeeping)できます。

### 手動トリガー {#manual-trigger}

リポジトリの管理者は、リポジトリでハウスキーピングタスクを手動でトリガーできます。一般に、GitLabはハウスキーピングタスクを自動的に実行することがわかっているので、これは必要ありません。手動トリガーは、次の場合に役立ちます:

- リポジトリがハウスキーピングを必要とすることがわかっている。
- ハウスキーピングタスクの自動化されたプッシュベースのスケジュールが無効になっている。

ハウスキーピングタスクを手動でトリガーするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **ハウスキーピングを実行**を選択します。

これにより、プロジェクトのリポジトリの非同期バックグラウンドワーカーが開始されます。バックグラウンドワーカーは、Gitalyに多数の最適化を実行するように要求します。

ハウスキーピングは、プロジェクトから[参照されていないLFSファイルを削除](raketasks/cleanup.md#remove-unreferenced-lfs-files)し、`200`プッシュごとにプロジェクトのストレージスペースを解放します。

### 到達不能オブジェクトをプルーニング {#prune-unreachable-objects}

到達不能オブジェクトは、スケジュールされたハウスキーピングの一部としてプルーニングされます。ただし、手動プルーニングをトリガーすることもできます。ハウスキーピングをトリガーすると、2週間の猶予期間で到達不能オブジェクトがプルーニングされます。到達不能オブジェクトのプルーニングを手動でトリガーすると、猶予期間は30分に短縮されます。

{{< alert type="warning" >}}

到達不能オブジェクトをプルーニングしても、流出したシークレットやその他の機密情報が削除されるとは限りません。コミットされてもプッシュされなかったシークレットを削除する方法については、[コミットからシークレットを削除するチュートリアル](../user/application_security/secret_detection/remove_secrets_tutorial.md)を参照してください。さらに、[blobを個別に削除](../user/project/repository/repository_size.md#remove-blobs)できます。その操作を実行した場合に考えられる結果については、そのドキュメントを参照してください。

同時処理（`git push`など）がオブジェクトを作成したが、オブジェクトへの参照をまだ作成していない場合、オブジェクトが削除された後でオブジェクトへの参照が追加されると、リポジトリが破損する可能性があります。猶予期間は、そのような競合状態の可能性を減らすために存在します。たとえば、非常に遅い接続を介して多数の大きなオブジェクトを頻繁にプッシュする場合、到達不能オブジェクトをプルーニングすることに伴うリスクは、プロジェクトに社内からパフォーマンスの高い接続でのみアクセスできる企業環境よりもはるかに高くなります。このオプションを使用する場合は、プロジェクトの使用状況プロファイルを考慮し、静止期間を選択してください。

{{< /alert >}}

到達不能オブジェクトの手動プルーニングをトリガーするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **ハウスキーピングを実行**を選択します。
1. 操作が完了するまで30分お待ちください。
1. **ハウスキーピングを実行**を選択したページに戻り、**到達不能オブジェクトを排除する**を選択します。

### スケジュールされたハウスキーピング {#scheduled-housekeeping}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

GitLabはプッシュの数に基づいてハウスキーピングタスクを自動的に実行しますが、プッシュをまったく受信しないリポジトリは維持しません。その結果、休止状態のリポジトリ、または読み取りリクエストのみを取得しているリポジトリは、リポジトリハウスキーピング戦略の改善の恩恵を受けられない場合があります。

管理者は、カスタマイズ可能な間隔ですべてのリポジトリでハウスキーピングを実行するバックグラウンドジョブを有効にして、この状況を改善できます。このバックグラウンドジョブは、Gitalyノードによってホストされているすべてのリポジトリをランダムな順序で処理し、それらに対してEagerハウスキーピングタスクを熱心に実行します。Gitalyノードは、設定された間隔よりも時間がかかる場合、リポジトリの処理を停止します。

#### スケジュールされたハウスキーピングを設定する {#configure-scheduled-housekeeping}

Gitリポジトリのバックグラウンドメンテナンスは、Gitalyで設定されます。デフォルトでは、Gitalyは毎日午後12:00にバックグラウンドリポジトリメンテナンスを10分間実行します。

このデフォルトは、Gitalyの設定で変更できます。

Gitalyクラスタリング（Praefect）を使用する環境では、スケジュールされたハウスキーピングの開始時間をGitalyノード間でずらすことができるため、スケジュールされたハウスキーピングが複数のノードで同時に実行されることはありません。

スケジュールされたハウスキーピングの実行が指定された`duration`に達すると、実行中のタスクは正常にキャンセルされます。後続のスケジュールされたハウスキーピングの実行では、Gitalyは処理するリポジトリリストをランダムにシャッフルします。

次のスニペットを使用すると、`default`ストレージの23:00から1時間、毎日のバックグラウンドリポジトリメンテナンスを有効にできます:

{{< tabs >}}

{{< tab title="自己コンパイル（ソース）" >}}

```toml
[daily_maintenance]
start_hour = 23
start_minute = 00
duration = 1h
storages = ["default"]
```

次のスニペットを使用して、バックグラウンドリポジトリメンテナンスを完全に無効にします:

```toml
[daily_maintenance]
disabled = true
```

{{< /tab >}}

{{< tab title="Linuxパッケージ（Omnibus）" >}}

```ruby
gitaly['configuration'] = {
  daily_maintenance: {
    disabled: false,
    start_hour: 23,
    start_minute: 00,
    duration: '1h',
    storages: ['default'],
  },
}
```

次のスニペットを使用して、バックグラウンドリポジトリメンテナンスを完全に無効にします:

```ruby
gitaly['configuration'] = {
  daily_maintenance: {
    disabled: true,
  },
}
```

{{< /tab >}}

{{< /tabs >}}

スケジュールされたハウスキーピングが実行されると、[Gitalyログ](logs/_index.md#gitaly-logs)に次のエントリが表示されます:

```json
# When the scheduled housekeeping starts
{"level":"info","msg":"maintenance: daily scheduled","pid":197260,"scheduled":"2023-09-27T13:10:00+13:00","time":"2023-09-27T00:08:31.624Z"}

# When the scheduled housekeeping completes
{"actual_duration":321181874818,"error":null,"level":"info","max_duration":"1h0m0s","msg":"maintenance: daily completed","pid":197260,"time":"2023-09-27T00:15:21.182Z"}
```

`actual_duration`（ナノ秒単位）は、スケジュールされたメンテナンスの実行にかかった時間を示します。前の例では、スケジュールされたハウスキーピングは5分強で完了しました。

## オブジェクトプールリポジトリ {#object-pool-repositories}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

オブジェクトプールリポジトリは、リポジトリのフォーク間でオブジェクトを重複排除するためにGitLabによって使用されます。最初のフォークを作成するときは、次の手順を実行します:

1. フォークされようとしているリポジトリのすべてのオブジェクトを含むオブジェクトプールリポジトリを作成します。
1. Gitの代替メカニズムを使用して、リポジトリをこの新しいオブジェクトプールにリンクします。
1. リポジトリを再パックして、オブジェクトプールからオブジェクトを使用するようにします。したがって、オブジェクト自体のコピーをドロップできます。

このリポジトリのフォークは、オブジェクトプールに対してリンクできるようになり、プライマリリポジトリとは異なるオブジェクトのみを保持する必要があります。

GitLabは、オブジェクトプールで特別なハウスキーピング操作を実行する必要があります:

- Gitalyは、接続されているフォークのいずれかで使用される可能性があるため、オブジェクトプールから到達不能オブジェクトを削除することはできません。
- Gitalyは、同じ理由で、到達可能なすべてのオブジェクトを保持する必要があります。したがって、オブジェクトプールは、削除されないように、到達不能な「ぶら下がっている」オブジェクトへの参照を維持します。
- GitLabは、プライマリリポジトリに追加された新しいオブジェクトをプルするために、オブジェクトプールを定期的に更新する必要があります。そうしないと、オブジェクトプールはオブジェクトの重複排除においてますます非効率になります。

これらのハウスキーピング操作は、標準のGitリポジトリに対して実行する通常のハウスキーピングタスクも実行しながら、これらの特別なタスクすべてを処理する、特殊化された`FetchIntoObjectPool` RPCsによって実行されます。

オブジェクトプールは、プライマリメンバーがガベージコレクションされるたびに自動的に最適化されます。したがって、プロジェクト内の同じGit GC期間を使用して、ケイデンスを設定できます。

[Railsコンソール](operations/rails_console.md)から手動でRPCsを呼び出す必要がある場合は、`project.pool_repository.object_pool.fetch`を呼び出すことができます。これは潜在的に長時間実行されるタスクですが、Gitalyは約8時間後にタイムアウトします。
