/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ChatMessageStyleApplier {
    public void apply(JEditorPane messageHistoryPane, HTMLEditorKit messageHistoryEditorKit) {
        boolean darkTheme;
        Color baseBackground = UIManager.getColor("TextArea.background");
        Color baseForeground = UIManager.getColor("TextArea.foreground");
        if (baseBackground == null) {
            baseBackground = Color.WHITE;
        }
        if (baseForeground == null) {
            baseForeground = Color.BLACK;
        }
        Color userBackground = (darkTheme = this.isDark(baseBackground)) ? new Color(69, 69, 69) : new Color(235, 235, 235);
        Color assistantBackground = darkTheme ? new Color(43, 43, 43) : new Color(245, 245, 245);
        Color toolBackground = darkTheme ? new Color(42, 54, 70) : new Color(234, 243, 255);
        Color mcpBackground = darkTheme ? new Color(37, 51, 84) : new Color(234, 243, 255);
        Color systemBackground = darkTheme ? new Color(31, 31, 31) : new Color(240, 240, 240);
        Color profileBackground = darkTheme ? new Color(28, 44, 36) : new Color(232, 246, 236);
        Color userBorderColor = darkTheme ? new Color(106, 106, 106) : new Color(62, 62, 62);
        Color borderColor = darkTheme ? new Color(82, 82, 82) : new Color(215, 215, 215);
        Color toolBorderColor = darkTheme ? new Color(90, 111, 138) : new Color(188, 217, 255);
        Color mcpBorderColor = darkTheme ? new Color(106, 127, 176) : new Color(92, 121, 189);
        Color systemBorderColor = darkTheme ? new Color(58, 58, 58) : new Color(176, 176, 176);
        Color profileBorderColor = darkTheme ? new Color(63, 112, 88) : new Color(77, 154, 114);
        messageHistoryPane.setBackground(baseBackground);
        StyleSheet baseStyleSheet = messageHistoryEditorKit.getStyleSheet();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addStyleSheet(baseStyleSheet);
        HTMLDocument document = new HTMLDocument(styleSheet);
        messageHistoryPane.setDocument(document);
        styleSheet.addRule("body { font-family: Sans-Serif; font-size: 12pt; margin: 6px; color: " + this.toCssColor(baseForeground) + "; background-color: " + this.toCssColor(baseBackground) + "; }");
        styleSheet.addRule(".message-user { margin: 6px 0; padding: 6px 8px; background-color: " + this.toCssColor(userBackground) + "; border-left: 4px solid " + this.toCssColor(userBorderColor) + "; }");
        styleSheet.addRule(".message-assistant { margin: 6px 0; padding: 6px 8px; background-color: " + this.toCssColor(assistantBackground) + "; border-left: 4px solid " + this.toCssColor(borderColor) + "; }");
        styleSheet.addRule(".message-tool { margin: 6px 0; padding: 6px 8px; background-color: " + this.toCssColor(toolBackground) + "; border-left: 4px solid " + this.toCssColor(toolBorderColor) + "; }");
        styleSheet.addRule(".message-mcp-call { margin: 6px 0; padding: 6px 8px; background-color: " + this.toCssColor(mcpBackground) + "; border-left: 8px solid " + this.toCssColor(mcpBorderColor) + "; }");
        styleSheet.addRule(".message-system { margin: 6px 0; padding: 6px 8px; background-color: " + this.toCssColor(systemBackground) + "; border-left: 4px solid " + this.toCssColor(systemBorderColor) + "; }");
        styleSheet.addRule(".message-profile { margin: 6px 0; padding: 6px 8px; background-color: " + this.toCssColor(profileBackground) + "; border-left: 4px solid " + this.toCssColor(profileBorderColor) + "; }");
        styleSheet.addRule(".message-context-boundary { margin: 10px 0 6px 0; padding: 4px 8px 0 8px; border-top: 2px dashed " + this.toCssColor(systemBorderColor) + "; color: " + this.toCssColor(systemBorderColor) + "; font-size: 10pt; }");
    }

    private boolean isDark(Color color) {
        double luminance = 0.2126 * (double)color.getRed() + 0.7152 * (double)color.getGreen() + 0.0722 * (double)color.getBlue();
        return luminance < 128.0;
    }

    private String toCssColor(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

