/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.freeplane.plugin.ai.chat.AIModelDescriptor;
import org.freeplane.plugin.ai.chat.AIProviderConfiguration;

class AIModelCatalog {
    private static final long OPENROUTER_REFRESH_INTERVAL_MILLISECONDS = 1800000L;
    private static final Object openrouterLock = new Object();
    private static long lastOpenrouterRefreshTime;
    private static List<AIModelDescriptor> cachedOpenrouterModels;
    private static final Object ollamaLock;
    private static long lastOllamaRefreshTime;
    private static List<AIModelDescriptor> cachedOllamaModels;
    private final AIProviderConfiguration configuration;
    private final ObjectMapper objectMapper;

    AIModelCatalog(AIProviderConfiguration configuration) {
        this.configuration = configuration;
        this.objectMapper = new ObjectMapper();
    }

    List<AIModelDescriptor> getAvailableModels(boolean allowsRefresh) {
        ArrayList<AIModelDescriptor> modelDescriptors = new ArrayList<AIModelDescriptor>();
        if (this.hasOpenrouterKey()) {
            List<AIModelDescriptor> openrouterModels = this.getOpenrouterModels(allowsRefresh);
            modelDescriptors.addAll(this.filterModelDescriptors(openrouterModels, this.configuration.getOpenrouterModelAllowlistValue()));
        }
        if (this.hasGeminiKey()) {
            modelDescriptors.addAll(this.getGeminiModelsFromList());
        }
        if (this.configuration.isOllamaEnabled()) {
            List<AIModelDescriptor> ollamaModels = this.getOllamaModels(allowsRefresh);
            modelDescriptors.addAll(this.filterModelDescriptors(ollamaModels, this.configuration.getOllamaModelAllowlistValue()));
        }
        return modelDescriptors;
    }

    private boolean hasOpenrouterKey() {
        String openrouterKey = this.configuration.getOpenRouterKey();
        return openrouterKey != null && !openrouterKey.isEmpty();
    }

    private boolean hasGeminiKey() {
        String geminiKey = this.configuration.getGeminiKey();
        return geminiKey != null && !geminiKey.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AIModelDescriptor> getOpenrouterModels(boolean allowsRefresh) {
        if (!allowsRefresh) {
            return cachedOpenrouterModels;
        }
        Object object = openrouterLock;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastOpenrouterRefreshTime < 1800000L) {
                return cachedOpenrouterModels;
            }
            List<AIModelDescriptor> refreshedModels = this.fetchOpenrouterModels();
            cachedOpenrouterModels = refreshedModels;
            lastOpenrouterRefreshTime = currentTime;
            return cachedOpenrouterModels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AIModelDescriptor> getOllamaModels(boolean allowsRefresh) {
        if (!allowsRefresh) {
            return cachedOllamaModels;
        }
        Object object = ollamaLock;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastOllamaRefreshTime < 1800000L) {
                return cachedOllamaModels;
            }
            List<AIModelDescriptor> refreshedModels = this.fetchOllamaModels();
            cachedOllamaModels = refreshedModels;
            lastOllamaRefreshTime = currentTime;
            return cachedOllamaModels;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<AIModelDescriptor> fetchOpenrouterModels() {
        String serviceAddress = this.configuration.getOpenrouterServiceAddress();
        if (serviceAddress == null || serviceAddress.isEmpty()) {
            serviceAddress = "https://openrouter.ai/api/v1";
        }
        String modelsAddress = serviceAddress.endsWith("/") ? serviceAddress + "models" : serviceAddress + "/models";
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(modelsAddress).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("HTTP-Referer", "https://github.com/freeplane/freeplane");
            connection.setRequestProperty("X-Title", "Freeplane");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return Collections.emptyList();
            }
            try (InputStream inputStream = connection.getInputStream();){
                List<AIModelDescriptor> list;
                try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    list = this.parseOpenrouterModelsResponse(reader);
                }
                return list;
            }
        }
        catch (IOException exception) {
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<AIModelDescriptor> fetchOllamaModels() {
        String serviceAddress = this.configuration.getOllamaServiceAddress();
        if (serviceAddress == null || serviceAddress.isEmpty()) {
            serviceAddress = "http://localhost:11434";
        }
        String modelsAddress = serviceAddress.endsWith("/") ? serviceAddress + "api/tags" : serviceAddress + "/api/tags";
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(modelsAddress).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return Collections.emptyList();
            }
            try (InputStream inputStream = connection.getInputStream();){
                List<AIModelDescriptor> list;
                try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    list = this.parseOllamaModelsResponse(reader);
                }
                return list;
            }
        }
        catch (IOException exception) {
            return Collections.emptyList();
        }
    }

    List<AIModelDescriptor> parseOpenrouterModelsResponse(Reader reader) throws IOException {
        OpenrouterModelsResponse response = (OpenrouterModelsResponse)this.objectMapper.readValue(reader, OpenrouterModelsResponse.class);
        if (response == null || response.models == null) {
            return Collections.emptyList();
        }
        ArrayList<AIModelDescriptor> modelDescriptors = new ArrayList<AIModelDescriptor>();
        for (OpenrouterModelItem modelItem : response.models) {
            if (modelItem == null || modelItem.modelIdentifier == null) continue;
            boolean isFreeModel = this.isFreePricing(modelItem.pricing);
            modelDescriptors.add(new AIModelDescriptor("openrouter", modelItem.modelIdentifier, this.buildDisplayName("openrouter", modelItem.modelIdentifier, isFreeModel), isFreeModel));
        }
        return modelDescriptors;
    }

    List<AIModelDescriptor> parseOllamaModelsResponse(Reader reader) throws IOException {
        OllamaModelsResponse response = (OllamaModelsResponse)this.objectMapper.readValue(reader, OllamaModelsResponse.class);
        if (response == null || response.models == null) {
            return Collections.emptyList();
        }
        ArrayList<AIModelDescriptor> modelDescriptors = new ArrayList<AIModelDescriptor>();
        for (OllamaModelItem modelItem : response.models) {
            if (modelItem == null || modelItem.modelName == null || modelItem.modelName.isEmpty()) continue;
            modelDescriptors.add(new AIModelDescriptor("ollama", modelItem.modelName, this.buildDisplayName("ollama", modelItem.modelName, false), false));
        }
        return modelDescriptors;
    }

    List<AIModelDescriptor> filterModelDescriptors(List<AIModelDescriptor> modelDescriptors, String allowlistValue) {
        if (modelDescriptors.isEmpty()) {
            return modelDescriptors;
        }
        List<Pattern> allowlistPatterns = this.parseModelAllowlistPatterns(allowlistValue);
        if (allowlistPatterns.isEmpty()) {
            return modelDescriptors;
        }
        ArrayList<AIModelDescriptor> filteredDescriptors = new ArrayList<AIModelDescriptor>();
        for (AIModelDescriptor modelDescriptor : modelDescriptors) {
            if (modelDescriptor == null || !this.matchesAllowlist(modelDescriptor.getModelName(), allowlistPatterns)) continue;
            filteredDescriptors.add(modelDescriptor);
        }
        return filteredDescriptors;
    }

    private List<Pattern> parseModelAllowlistPatterns(String allowlistValue) {
        String[] entries;
        if (allowlistValue == null || allowlistValue.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String entry : entries = allowlistValue.split("[,\\r\\n]+")) {
            String trimmedEntry = entry.trim();
            if (trimmedEntry.isEmpty()) continue;
            patterns.add(Pattern.compile(this.convertWildcardToRegex(trimmedEntry)));
        }
        return patterns;
    }

    private boolean matchesAllowlist(String modelName, List<Pattern> allowlistPatterns) {
        if (modelName == null || modelName.isEmpty()) {
            return false;
        }
        for (Pattern pattern : allowlistPatterns) {
            if (!pattern.matcher(modelName).matches()) continue;
            return true;
        }
        return false;
    }

    private String convertWildcardToRegex(String wildcardPattern) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < wildcardPattern.length(); ++index) {
            char character = wildcardPattern.charAt(index);
            if (character == '*') {
                builder.append(".*");
                continue;
            }
            if (character == '?') {
                builder.append('.');
                continue;
            }
            if ("\\.^$|()[]{}+".indexOf(character) >= 0) {
                builder.append('\\');
            }
            builder.append(character);
        }
        return builder.toString();
    }

    private String buildDisplayName(String providerName, String modelName, boolean isFreeModel) {
        String providerDisplayName = "openrouter".equals(providerName) ? "OpenRouter" : ("gemini".equals(providerName) ? "Gemini" : ("ollama".equals(providerName) ? "Ollama" : providerName));
        String displayName = providerDisplayName + ": " + modelName;
        if (isFreeModel) {
            displayName = displayName + " (free)";
        }
        return displayName;
    }

    private boolean isFreePricing(OpenrouterModelPricing pricing) {
        if (pricing == null) {
            return false;
        }
        return this.isZeroCost(pricing.promptPrice) && this.isZeroCost(pricing.completionPrice);
    }

    private boolean isZeroCost(String price) {
        if (price == null || price.isEmpty()) {
            return false;
        }
        try {
            return Double.parseDouble(price) == 0.0;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    List<AIModelDescriptor> parseGeminiModelList(String modelListValue) {
        String[] entries;
        if (modelListValue == null || modelListValue.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AIModelDescriptor> modelDescriptors = new ArrayList<AIModelDescriptor>();
        for (String entry : entries = modelListValue.split("[,\\r\\n]+")) {
            String trimmedEntry = entry.trim();
            if (trimmedEntry.isEmpty()) continue;
            modelDescriptors.add(new AIModelDescriptor("gemini", trimmedEntry, this.buildDisplayName("gemini", trimmedEntry, false), false));
        }
        return modelDescriptors;
    }

    private List<AIModelDescriptor> getGeminiModelsFromList() {
        return this.parseGeminiModelList(this.configuration.getGeminiModelListValue());
    }

    static {
        cachedOpenrouterModels = Collections.emptyList();
        ollamaLock = new Object();
        cachedOllamaModels = Collections.emptyList();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class OpenrouterModelsResponse {
        @JsonProperty(value="data")
        private List<OpenrouterModelItem> models;

        private OpenrouterModelsResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class OpenrouterModelItem {
        @JsonProperty(value="id")
        private String modelIdentifier;
        @JsonProperty(value="pricing")
        private OpenrouterModelPricing pricing;

        private OpenrouterModelItem() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class OpenrouterModelPricing {
        @JsonProperty(value="prompt")
        private String promptPrice;
        @JsonProperty(value="completion")
        private String completionPrice;

        private OpenrouterModelPricing() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class OllamaModelsResponse {
        @JsonProperty(value="models")
        private List<OllamaModelItem> models;

        private OllamaModelsResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class OllamaModelItem {
        @JsonProperty(value="name")
        private String modelName;

        private OllamaModelItem() {
        }
    }
}

