/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketWrapperBase;

public class Nio2Channel
implements AsynchronousByteChannel {
    protected static final ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    protected final SocketBufferHandler bufHandler;
    protected AsynchronousSocketChannel sc = null;
    protected SocketWrapperBase<Nio2Channel> socketWrapper = null;
    private static final Future<Boolean> DONE = new Future<Boolean>(){

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            return Boolean.TRUE;
        }

        @Override
        public Boolean get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return Boolean.TRUE;
        }
    };
    private ApplicationBufferHandler appReadBufHandler;
    private static final Future<Integer> DONE_INT = new Future<Integer>(){

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            return -1;
        }

        @Override
        public Integer get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return -1;
        }
    };
    static final Nio2Channel CLOSED_NIO2_CHANNEL = new Nio2Channel(SocketBufferHandler.EMPTY){

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void reset(AsynchronousSocketChannel asynchronousSocketChannel, SocketWrapperBase<Nio2Channel> socketWrapperBase) throws IOException {
        }

        @Override
        public void free() {
        }

        @Override
        protected ApplicationBufferHandler getAppReadBufHandler() {
            return ApplicationBufferHandler.EMPTY;
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
        }

        @Override
        public Future<Integer> read(ByteBuffer byteBuffer) {
            return DONE_INT;
        }

        @Override
        public <A> void read(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
            completionHandler.failed(new ClosedChannelException(), a);
        }

        @Override
        public <A> void read(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
            completionHandler.failed(new ClosedChannelException(), a);
        }

        @Override
        public Future<Integer> write(ByteBuffer byteBuffer) {
            return DONE_INT;
        }

        @Override
        public <A> void write(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
            completionHandler.failed(new ClosedChannelException(), a);
        }

        @Override
        public <A> void write(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
            completionHandler.failed(new ClosedChannelException(), a);
        }

        @Override
        public String toString() {
            return "Closed Nio2Channel";
        }
    };

    public Nio2Channel(SocketBufferHandler socketBufferHandler) {
        this.bufHandler = socketBufferHandler;
    }

    public void reset(AsynchronousSocketChannel asynchronousSocketChannel, SocketWrapperBase<Nio2Channel> socketWrapperBase) throws IOException {
        this.sc = asynchronousSocketChannel;
        this.socketWrapper = socketWrapperBase;
        this.bufHandler.reset();
    }

    public void free() {
        this.bufHandler.free();
    }

    SocketWrapperBase<Nio2Channel> getSocketWrapper() {
        return this.socketWrapper;
    }

    @Override
    public void close() throws IOException {
        this.sc.close();
    }

    public void close(boolean bl) throws IOException {
        if (this.isOpen() || bl) {
            this.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.sc.isOpen();
    }

    public SocketBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    public AsynchronousSocketChannel getIOChannel() {
        return this.sc;
    }

    public boolean isClosing() {
        return false;
    }

    public boolean isHandshakeComplete() {
        return true;
    }

    public int handshake() throws IOException {
        return 0;
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.sc);
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer) {
        return this.sc.read(byteBuffer);
    }

    @Override
    public <A> void read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.read(byteBuffer, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    public <A> void read(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.sc.read(byteBuffer, l, timeUnit, a, completionHandler);
    }

    public <A> void read(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
        this.sc.read(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer) {
        return this.sc.write(byteBuffer);
    }

    @Override
    public <A> void write(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.write(byteBuffer, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    public <A> void write(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.sc.write(byteBuffer, l, timeUnit, a, completionHandler);
    }

    public <A> void write(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
        this.sc.write(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
    }

    public Future<Boolean> flush() {
        return DONE;
    }

    public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
        this.appReadBufHandler = applicationBufferHandler;
    }

    protected ApplicationBufferHandler getAppReadBufHandler() {
        return this.appReadBufHandler;
    }
}

