/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.offline.jdbc;

import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.Version;
import schemacrawler.tools.offline.jdbc.OfflineConnectionUtility;
import us.fatehi.utility.Utility;

public class OfflineDriver
implements Driver {
    private static final Logger LOGGER = Logger.getLogger(OfflineDriver.class.getName());
    private static final String JDBC_URL_PREFIX = "jdbc:offline:";

    @Override
    public boolean acceptsURL(String url) {
        return !Utility.isBlank((CharSequence)url) && url.startsWith(JDBC_URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            String path = url.substring(JDBC_URL_PREFIX.length());
            return (Connection)OfflineConnectionUtility.newOfflineDatabaseConnectionSource(Paths.get(path, new String[0])).get();
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return Integer.parseInt(Version.version().getProductVersion().split("\\.")[0]);
    }

    @Override
    public int getMinorVersion() {
        return Integer.parseInt(Version.version().getProductVersion().split("\\.")[1]);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported", "HYC00");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new OfflineDriver());
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Cannot register SchemaCrawler Offline Catalog Snapshot driver", e);
        }
    }
}

