/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.lint;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.command.lint.options.LintOptions;
import schemacrawler.tools.command.lint.options.LintReportOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.lint.LinterRegistry;
import schemacrawler.tools.lint.Linters;
import schemacrawler.tools.lint.Lints;
import schemacrawler.tools.lint.config.LinterConfigUtility;
import schemacrawler.tools.lint.config.LinterConfigs;
import schemacrawler.tools.lint.formatter.LintReportGenerator;
import schemacrawler.tools.lint.formatter.LintReportJsonGenerator;
import schemacrawler.tools.lint.formatter.LintReportTextFormatter;
import schemacrawler.tools.lint.formatter.LintReportTextGenerator;
import schemacrawler.tools.lint.formatter.LintReportYamlGenerator;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.ObjectToStringFormat;

public class LintCommand
extends BaseSchemaCrawlerCommand<LintOptions> {
    private static final Logger LOGGER = Logger.getLogger(LintCommand.class.getName());
    static final PropertyName COMMAND = new PropertyName("lint", "Find lints (non-adherence to coding standards and conventions) in the database schema");

    public LintCommand() {
        super(COMMAND);
    }

    public void checkAvailability() {
    }

    public void execute() {
        try {
            this.checkCatalog();
            LinterConfigs linterConfigs = LinterConfigUtility.readLinterConfigs((LintOptions)((Object)this.commandOptions));
            LOGGER.log(Level.FINEST, (Supplier<String>)new ObjectToStringFormat((Object)linterConfigs));
            Linters linters = new Linters(linterConfigs, ((LintOptions)((Object)this.commandOptions)).isRunAllLinters());
            LinterRegistry linterRegistry = LinterRegistry.getLinterRegistry();
            linters.initialize(linterRegistry);
            linters.lint(this.catalog, this.connection);
            Lints lints = linters.getLints();
            LOGGER.log(Level.INFO, "Generating lint report");
            this.getLintReportBuilder().generateLintReport(lints);
            linters.dispatch(((LintOptions)((Object)this.commandOptions)).getLintDispatch());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not run lint command", e);
        }
    }

    public boolean usesConnection() {
        return true;
    }

    private LintReportGenerator getLintReportBuilder() {
        LintReportGenerator lintReportGenerator;
        LintReportOutputFormat outputFormat = LintReportOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        switch (outputFormat) {
            case json: {
                lintReportGenerator = new LintReportJsonGenerator(this.outputOptions);
                break;
            }
            case yaml: {
                lintReportGenerator = new LintReportYamlGenerator(this.outputOptions);
                break;
            }
            default: {
                LintReportTextFormatter textFormatter = new LintReportTextFormatter((LintOptions)((Object)this.commandOptions), this.outputOptions, this.identifiers);
                LintReportTextGenerator textGenerator = new LintReportTextGenerator();
                textGenerator.setCatalog(this.catalog);
                textGenerator.setHandler(textFormatter);
                lintReportGenerator = textGenerator;
            }
        }
        return lintReportGenerator;
    }
}

