/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.function.Predicate;
import schemacrawler.filter.DatabaseObjectFilter;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.filter.RoutineGrepFilter;
import schemacrawler.filter.RoutineTypesFilter;
import schemacrawler.filter.TableGrepFilter;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public final class FilterFactory {
    public static Predicate<Routine> routineFilter(SchemaCrawlerOptions options) {
        LimitOptions limitOptions = options.getLimitOptions();
        Predicate<Routine> routineFilter = new RoutineTypesFilter(limitOptions).and(new DatabaseObjectFilter(limitOptions, DatabaseObjectRuleForInclusion.ruleForRoutineInclusion)).and(new RoutineGrepFilter(options.getGrepOptions()));
        return routineFilter;
    }

    public static Predicate<Schema> schemaFilter(SchemaCrawlerOptions options) {
        return new InclusionRuleFilter<Schema>(options.getLimitOptions().get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion), true);
    }

    public static Predicate<Sequence> sequenceFilter(SchemaCrawlerOptions options) {
        return new DatabaseObjectFilter<Sequence>(options.getLimitOptions(), DatabaseObjectRuleForInclusion.ruleForSequenceInclusion);
    }

    public static Predicate<Synonym> synonymFilter(SchemaCrawlerOptions options) {
        return new DatabaseObjectFilter<Synonym>(options.getLimitOptions(), DatabaseObjectRuleForInclusion.ruleForSynonymInclusion);
    }

    public static Predicate<Table> tableFilter(SchemaCrawlerOptions options) {
        LimitOptions limitOptions = options.getLimitOptions();
        Predicate<Table> tableFilter = new TableTypesFilter(limitOptions).and(new DatabaseObjectFilter(limitOptions, DatabaseObjectRuleForInclusion.ruleForTableInclusion)).and(new TableGrepFilter(options.getGrepOptions()));
        return tableFilter;
    }

    private FilterFactory() {
    }
}

