/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.command.script.AbstractScriptExecutor;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.string.StringFormat;

abstract class AbstractScriptEngineExecutor
extends AbstractScriptExecutor {
    private static final Logger LOGGER = Logger.getLogger(AbstractScriptEngineExecutor.class.getName());
    protected ScriptEngine scriptEngine;

    private static void logScriptEngineDetails(Level level, ScriptEngineFactory scriptEngineFactory) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LOGGER.log(level, String.format("Using script engine%n%s %s (%s %s)%nScript engine names: %s%nSupported file extensions: %s", scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), ObjectToString.toString(scriptEngineFactory.getNames()), ObjectToString.toString(scriptEngineFactory.getExtensions())));
    }

    public AbstractScriptEngineExecutor(String scriptingLanguage) {
        super(scriptingLanguage);
    }

    @Override
    public void run() {
        this.obtainScriptEngine();
        Objects.requireNonNull(this.scriptEngine, "Script engine not found");
        AbstractScriptEngineExecutor.logScriptEngineDetails(Level.CONFIG, this.scriptEngine.getFactory());
        Objects.requireNonNull(this.reader, "No reader provided");
        Objects.requireNonNull(this.writer, "No writer provided");
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Evaluating script", new Object[0]));
        try (Reader reader = this.reader;
             Writer writer = this.writer;){
            this.scriptEngine.getContext().setWriter(writer);
            for (Map.Entry contextValue : this.context.entrySet()) {
                this.scriptEngine.put((String)contextValue.getKey(), contextValue.getValue());
            }
            if (this.scriptEngine instanceof Compilable) {
                CompiledScript script = ((Compilable)((Object)this.scriptEngine)).compile(reader);
                Object result = script.eval();
                LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Script execution result:%n%s", new Object[]{result}));
            } else {
                this.scriptEngine.eval(reader);
            }
        }
        catch (ScriptException e) {
            throw new ExecutionRuntimeException("Could not execute script", (Throwable)e);
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not read script", e);
        }
    }

    protected abstract void obtainScriptEngine();
}

