/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import us.fatehi.utility.string.StringFormat;

final class TableExtRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableExtRetriever.class.getName());

    TableExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalColumnAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional column attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional column attributes SQL statement was not provided");
            return;
        }
        Query columnAttributesSql = informationSchemaViews.getQuery(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tableColumnAdditionalAttributesRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving additional column attributes, using fast data dictionary retrieval over schemas");
                this.retrieveAdditionalColumnAttributesOverSchemas(columnAttributesSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving additional column attributes, using fast data dictionary retrieval");
                this.retrieveAdditionalColumnAttributesFromDataDictionary(columnAttributesSql);
            }
        }
    }

    void retrieveAdditionalColumnMetadata() {
        String name = "columns with additional metadata";
        RetrievalCounts retrievalCounts = new RetrievalCounts("columns with additional metadata");
        try (Connection connection = this.getRetrieverConnection().getConnection("columns with additional metadata");){
            EnumDataTypeHelper enumDataTypeHelper = this.getRetrieverConnection().getEnumDataTypeHelper();
            NamedObjectList<MutableTable> tables = this.catalog.getAllTables();
            for (MutableTable table : tables) {
                retrievalCounts.count();
                NamedObjectList<MutableColumn> columns = table.getAllColumns();
                for (MutableColumn column : columns) {
                    MutableColumnDataType columnDataType = (MutableColumnDataType)column.getColumnDataType();
                    EnumDataTypeInfo enumDataTypeInfo = enumDataTypeHelper.getEnumDataTypeInfo(column, columnDataType, connection);
                    switch (enumDataTypeInfo.getType()) {
                        case enumerated_column: {
                            MutableColumnDataType copiedColumnDataType;
                            columnDataType = copiedColumnDataType = new MutableColumnDataType(columnDataType);
                            columnDataType.setEnumValues(enumDataTypeInfo.getEnumValues());
                            retrievalCounts.countIncluded();
                            break;
                        }
                        case enumerated_data_type: {
                            columnDataType.setEnumValues(enumDataTypeInfo.getEnumValues());
                            retrievalCounts.countIncluded();
                            break;
                        }
                    }
                    column.setColumnDataType(columnDataType);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column metadata", e);
        }
        retrievalCounts.log();
    }

    void retrieveAdditionalTableAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional table attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional table attributes SQL statement was not provided");
            return;
        }
        Query tableAttributesSql = informationSchemaViews.getQuery(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tableAdditionalAttributesRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving additional table attributes, using fast data dictionary retrieval over schemas");
                this.retrieveAdditionalTableAttributesOverSchemas(tableAttributesSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving additional table attributes, using fast data dictionary retrieval");
                this.retrieveAdditionalTableAttributesFromDataDictionary(tableAttributesSql);
            }
        }
    }

    void retrieveTableDefinitions() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_TABLES)) {
            LOGGER.log(Level.INFO, "Not retrieving table definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Table definitions SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving table definitions");
        String name = "table definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("table definitions");
        Query tableDefinitionsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_TABLES);
        try (Connection connection = this.getRetrieverConnection().getConnection("table definitions");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableDefinitionsInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
                    continue;
                }
                MutableTable table = tableOptional.get();
                LOGGER.log(Level.FINER, new StringFormat("Retrieving table information <%s>", tableName));
                String definition = results.getString("TABLE_DEFINITION");
                table.setDefinition(definition);
                table.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table definitions", e);
        }
        retrievalCounts.log();
    }

    private boolean addAdditionalColumnAttributes(MetadataResultSet results) throws SQLException {
        String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
        String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
        String tableName = results.getString("TABLE_NAME");
        String columnName = results.getString("COLUMN_NAME");
        LOGGER.log(Level.FINER, "Retrieving additional column attributes: " + columnName);
        Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
        if (!tableOptional.isPresent()) {
            LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
            return false;
        }
        MutableTable table = tableOptional.get();
        Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
        if (!columnOptional.isPresent()) {
            LOGGER.log(Level.FINE, new StringFormat("Cannot find column <%s.%s.%s.%s>", catalogName, schemaName, tableName, columnName));
            return false;
        }
        MutableColumn column = columnOptional.get();
        column.addAttributes(results.getAttributes());
        return true;
    }

    private boolean addAdditionalTableAttributes(MetadataResultSet results) throws SQLException {
        String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
        String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
        String tableName = results.getString("TABLE_NAME");
        LOGGER.log(Level.FINER, "Retrieving additional table attributes: " + tableName);
        Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
        if (!tableOptional.isPresent()) {
            LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
            return false;
        }
        MutableTable table = tableOptional.get();
        table.addAttributes(results.getAttributes());
        return true;
    }

    private void retrieveAdditionalColumnAttributesFromDataDictionary(Query columnAttributesSql) throws SQLException {
        String name = "columns with attibutes";
        RetrievalCounts retrievalCounts = new RetrievalCounts("columns with attibutes");
        try (Connection connection = this.getRetrieverConnection().getConnection("columns with attibutes");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(columnAttributesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.addAdditionalColumnAttributes(results);
                retrievalCounts.countIfIncluded(added);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column attributes", e);
        }
        retrievalCounts.log();
    }

    private void retrieveAdditionalColumnAttributesOverSchemas(Query columnAttributesSql) throws SQLException {
        String name = "columns with attibutes over schemas";
        RetrievalCounts retrievalCounts = new RetrievalCounts("columns with attibutes over schemas");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("columns with attibutes over schemas");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(columnAttributesSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean added = this.addAdditionalColumnAttributes(results);
                    retrievalCounts.countIfIncluded(schema.key(), added);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, new StringFormat("Could not retrieve additional column attributes for schema <%s>", schema));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }

    private void retrieveAdditionalTableAttributesFromDataDictionary(Query tableAttributesSql) throws SQLException {
        String name = "tables with attributes";
        RetrievalCounts retrievalCounts = new RetrievalCounts("tables with attributes");
        try (Connection connection = this.getRetrieverConnection().getConnection("tables with attributes");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableAttributesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.addAdditionalTableAttributes(results);
                retrievalCounts.countIfIncluded(added);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional table attributes", e);
        }
        retrievalCounts.log();
    }

    private void retrieveAdditionalTableAttributesOverSchemas(Query tableAttributesSql) throws SQLException {
        String name = "tables with attributes over schemas";
        RetrievalCounts retrievalCounts = new RetrievalCounts("tables with attributes over schemas");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("tables with attributes over schemas");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(tableAttributesSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean added = this.addAdditionalTableAttributes(results);
                    retrievalCounts.countIfIncluded(schema.key(), added);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, new StringFormat("Could not retrieve additional table attributes for schema <%s>", schema));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

