# Async::REST

Roy Thomas Fielding's thesis [Architectural Styles and the Design of Network-based Software Architectures](https://www.ics.uci.edu/~fielding/pubs/dissertation/top.htm) describes [Representational State Transfer](https://www.ics.uci.edu/~fielding/pubs/dissertation/rest_arch_style.htm) which comprises several core concepts:

  - `Resource`: A conceptual mapping to one or more entities.
  - `Representation`: An instance of a resource at a given point in time.

This gem models these abstractions as closely and practically as possible and serves as a basis for building asynchronous web clients.

[![Development Status](https://github.com/socketry/async-rest/workflows/Test/badge.svg)](https://github.com/socketry/async-rest/actions?workflow=Test)

## Usage

Please see the [project documentation](https://socketry.github.io/async-rest/) for more details.

  - [Getting Started](https://socketry.github.io/async-rest/guides/getting-started/index) - This guide explains the design of the `async-rest` gem and how to use it to access RESTful APIs.

## Releases

Please see the [project releases](https://socketry.github.io/async-rest/releases/index) for all releases.

### v0.20.0

  - Migrated to `protocol-url` gem for URL handling.
  - Ensured instances are properly closed after use to prevent resource leaks.
  - All wrappers are now required by default from main `async/rest.rb` entry point.
  - Fixed logic to correctly parse JSON responses in `Form` wrapper.

### v0.19.1

  - Fixed `retry-after` header handling to treat it as a single value header.

### v0.19.0

  - Added support for standard `retry-after` rate limiting.
  - Improved response body handling to only replace the body if a parser is found.

### v0.18.0

  - Minor improvements and fixes to `Mutable`.

### v0.17.0

  - Bug fixes and minor improvements.

### v0.16.0

  - Removed legacy behaviour for cleaner implementation.

### v0.15.0

  - `Representation.for` can now take a block and return a custom representation.
  - Renamed methods to prefer `method` rather than `verb` for HTTP operations.

### v0.14.0

  - Fixed constant names.
  - Removed unused and legacy requires.

### v0.13.0

  - Better support for streaming responses.
  - Simplified interface for resources and representations.

### v0.12.4

  - Fixed `self.new` to use `self.class.new` for proper subclass instantiation.

## See Also

  - [async-ollama](https://github.com/socketry/async-ollama) - A client for Ollama, a local large language model server.
  - [async-discord](https://github.com/socketry/async-discord) - A client for Discord, a popular chat platform.
  - [cloudflare](https://github.com/socketry/cloudflare) - A client for Cloudflare, a popular CDN and DDoS protection service.
  - [async-slack](https://github.com/socketry/async-slack) - A client for Slack, a popular chat platform.

## Contributing

We welcome contributions to this project.

1.  Fork it.
2.  Create your feature branch (`git checkout -b my-new-feature`).
3.  Commit your changes (`git commit -am 'Add some feature'`).
4.  Push to the branch (`git push origin my-new-feature`).
5.  Create new Pull Request.

### Developer Certificate of Origin

In order to protect users of this project, we require all contributors to comply with the [Developer Certificate of Origin](https://developercertificate.org/). This ensures that all contributions are properly licensed and attributed.

### Community Guidelines

This project is best served by a collaborative and respectful environment. Treat each other professionally, respect differing viewpoints, and engage constructively. Harassment, discrimination, or harmful behavior is not tolerated. Communicate clearly, listen actively, and support one another. If any issues arise, please inform the project maintainers.
