\name{RankImageFilter}
\alias{RankImageFilter}
\title{RankImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Rank filter of a greyscale image.
RankImageFilter}
\details{
Nonlinear filter in which each output pixel is a user defined rank of
input pixels in a user defined neighborhood. The default rank is 0.5
(median). The boundary conditions are different to the standard
itkMedianImageFilter. In this filter the neighborhood is cropped at
the boundary, and is therefore smaller.
This filter uses a recursive implementation - essentially the one by
Huang 1979, I believe, to compute the rank, and is therefore usually a
lot faster than the direct implementation. The extensions to Huang are
support for arbitrary pixel types (using c++ maps) and arbitrary
neighborhoods. I presume that these are not new ideas.
This filter is based on the sliding window code from the
consolidatedMorphology package on InsightJournal.
The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.
This code was contributed in the Insight Journal paper: "Efficient
implementation of kernel filtering" by Beare R., Lehmann G https://www.insight-journal.org/browse/publication/160
See:
MedianImageFilter
Richard Beare
See:
Rank for the procedural interface
itk::RankImageFilter for the Doxygen on the original ITK class.
RankImageFilter}
%C++ includes: sitkRankImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element .
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{}
\item{double GetRank() const:}{}
\item{ RankImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element.
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{}
\item{Self SetRank(double Rank):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RankImageFilter():}{
Destructor
}
}
}
