\name{TikhonovDeconvolutionImageFilter}
\alias{TikhonovDeconvolutionImageFilter}
\title{TikhonovDeconvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
An inverse deconvolution filter regularized in the Tikhonov sense.
TikhonovDeconvolutionImageFilter}
\details{
The Tikhonov deconvolution filter is the inverse deconvolution filter
with a regularization term added to the denominator. The filter
minimizes the equation \deqn{ ||\hat{f} \otimes h - g||_{L_2}^2 + \mu||\hat{f}||^2 } where \eqn{\hat{f}} is the estimate of the unblurred image, \eqn{h} is the blurring kernel, \eqn{g} is the blurred image, and \eqn{\mu} is a non-negative real regularization function.
The filter applies a kernel described in the Fourier domain as \eqn{H^*(\omega) / (|H(\omega)|^2 + \mu)} where \eqn{H(\omega)} is the Fourier transform of \eqn{h} . The term \eqn{\mu} is called RegularizationConstant in this filter. If \eqn{\mu} is set to zero, this filter is equivalent to the InverseDeconvolutionImageFilter .
Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
Cory Quammen, The University of North Carolina at Chapel Hill
See:
TikhonovDeconvolution for the procedural interface
itk::TikhonovDeconvolutionImageFilter for the Doxygen on the original ITK class.
TikhonovDeconvolutionImageFilter}
%C++ includes: sitkTikhonovDeconvolutionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalize() const:}{}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{double GetRegularizationConstant() const:}{
The regularization factor. Larger values reduce the dominance of noise
in the solution, but results in higher approximation error in the
deblurred image. Default value is 0.0, yielding the same results as
the InverseDeconvolutionImageFilter .
}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{Self SetRegularizationConstant(double RegularizationConstant):}{
The regularization factor. Larger values reduce the dominance of noise
in the solution, but results in higher approximation error in the
deblurred image. Default value is 0.0, yielding the same results as
the InverseDeconvolutionImageFilter .
}
\item{ TikhonovDeconvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~TikhonovDeconvolutionImageFilter():}{
Destructor
}
}
}
