/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstAnnotationOwner;
import com.jetbrains.python.ast.PyAstClass;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstParameter;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.ast.PyAstSingleStarParameter;
import com.jetbrains.python.ast.PyAstTupleParameter;
import com.jetbrains.python.ast.PyAstTypeCommentOwner;
import com.jetbrains.python.ast.impl.ParamHelperCore;
import com.jetbrains.python.ast.impl.PyUtilCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstNamedParameter
extends PyAstParameter,
PsiNamedElement,
PsiNameIdentifierOwner,
PyAstExpression,
PyAstTypeCommentOwner,
PyAstAnnotationOwner {
    @Nullable
    default public ASTNode getNameIdentifierNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    @Nullable
    default public String getName() {
        ASTNode node = this.getNameIdentifierNode();
        return node != null ? node.getText() : null;
    }

    default public int getTextOffset() {
        ASTNode node = this.getNameIdentifierNode();
        return node == null ? this.getNode().getStartOffset() : node.getTextRange().getStartOffset();
    }

    @Nullable
    default public PsiElement getNameIdentifier() {
        ASTNode node = this.getNameIdentifierNode();
        return node == null ? null : node.getPsi();
    }

    default public boolean isPositionalContainer() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.MULT) != null;
    }

    default public boolean isKeywordContainer() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.EXP) != null;
    }

    @Override
    @Nullable
    default public PyAstExpression getDefaultValue() {
        ASTNode[] nodes = this.getNode().getChildren(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens());
        if (nodes.length > 0) {
            return (PyAstExpression)nodes[0].getPsi();
        }
        return null;
    }

    @Override
    default public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    @Override
    @Nullable
    default public String getDefaultValueText() {
        return ParamHelperCore.getDefaultValueText(this.getDefaultValue());
    }

    @NotNull
    default public String getRepr(boolean includeDefaultValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(ParamHelperCore.getNameInSignature(this));
        if (includeDefaultValue) {
            sb.append((String)ObjectUtils.notNull((Object)ParamHelperCore.getDefaultValuePartInSignature(this.getDefaultValueText(), false), (Object)""));
        }
        String string = sb.toString();
        if (string == null) {
            PyAstNamedParameter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    default public PyAstNamedParameter getAsNamed() {
        PyAstNamedParameter pyAstNamedParameter = this;
        if (pyAstNamedParameter == null) {
            PyAstNamedParameter.$$$reportNull$$$0(1);
        }
        return pyAstNamedParameter;
    }

    @Override
    @Nullable
    default public PyAstTupleParameter getAsTuple() {
        return null;
    }

    @Override
    @Nullable
    public PyAstAnnotation getAnnotation();

    default public boolean isKeywordOnly() {
        PyAstParameterList parameters = this.getStubOrPsiParentOfType(PyAstParameterList.class);
        if (parameters == null) {
            return false;
        }
        boolean varargSeen = false;
        for (PyAstParameter param : parameters.getParameters()) {
            if (param == this) break;
            PyAstNamedParameter named = param.getAsNamed();
            if ((named == null || !named.isPositionalContainer()) && !(param instanceof PyAstSingleStarParameter)) continue;
            varargSeen = true;
            break;
        }
        return varargSeen;
    }

    @Override
    default public boolean isSelf() {
        if (this.isPositionalContainer() || this.isKeywordContainer()) {
            return false;
        }
        PyAstFunction function = this.getStubOrPsiParentOfType(PyAstFunction.class);
        if (function == null) {
            return false;
        }
        PyAstClass cls = function.getContainingClass();
        PyAstParameter[] parameters = function.getParameterList().getParameters();
        if (cls != null && parameters.length > 0 && parameters[0] == this) {
            if (PyUtilCore.isNewMethod(function)) {
                return true;
            }
            PyAstFunction.Modifier modifier = function.getModifier();
            if (modifier != PyAstFunction.Modifier.STATICMETHOD) {
                return true;
            }
        }
        return false;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyNamedParameter(this);
    }

    @Override
    @Nullable
    default public PsiComment getTypeComment() {
        for (PsiElement next = this.getNextSibling(); next != null && !next.textContains('\n'); next = next.getNextSibling()) {
            if (next instanceof PsiWhiteSpace || ",".equals(next.getText())) continue;
            if (!(next instanceof PsiComment) || PyUtilCore.getTypeCommentValue(next.getText()) == null) break;
            return (PsiComment)next;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/ast/PyAstNamedParameter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepr";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsNamed";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

