/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AbstractHashingFunction;
import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.Utils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class BalloonHashingFunction
extends AbstractHashingFunction {
    private static final Map<String, BalloonHashingFunction> INSTANCES = new ConcurrentHashMap<String, BalloonHashingFunction>();
    private static final int DEFAULT_DELTA = 3;
    private final String algorithm;
    private final int spaceCost;
    private final int timeCost;
    private final int parallelism;
    private final int delta;
    private ExecutorService service;

    BalloonHashingFunction(String algorithm, int spaceCost, int timeCost, int parallelism, int delta) {
        this.algorithm = algorithm;
        this.spaceCost = spaceCost;
        this.timeCost = timeCost;
        this.parallelism = parallelism;
        this.delta = delta;
        if (parallelism > 1) {
            this.service = Utils.createExecutorService();
        }
    }

    public static BalloonHashingFunction getInstance(String algorithm, int spaceCost, int timeCost, int parallelism, int delta) {
        String key = BalloonHashingFunction.getUID(algorithm, spaceCost, timeCost, parallelism, delta);
        if (INSTANCES.containsKey(key)) {
            return INSTANCES.get(key);
        }
        BalloonHashingFunction function = new BalloonHashingFunction(algorithm, spaceCost, timeCost, parallelism, delta);
        INSTANCES.put(key, function);
        return function;
    }

    public static BalloonHashingFunction getInstance(String algorithm, int spaceCost, int timeCost, int parallelism) {
        return BalloonHashingFunction.getInstance(algorithm, spaceCost, timeCost, parallelism, 3);
    }

    private static String getUID(String algorithm, int spaceCost, int timeCost, int parallelism, int delta) {
        return algorithm + '|' + spaceCost + '|' + timeCost + '|' + parallelism + '|' + delta;
    }

    protected static String toString(String algorithm, int spaceCost, int timeCost, int parallelism, int delta) {
        return "a=" + algorithm + ", s=" + spaceCost + ", t=" + timeCost + ", p=" + parallelism + ", d=" + delta;
    }

    @Override
    public Hash hash(CharSequence plainTextPassword) {
        return null;
    }

    @Override
    public Hash hash(byte[] plainTextPassword) {
        return null;
    }

    @Override
    public Hash hash(CharSequence plainTextPassword, String salt) {
        return this.hash(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(salt));
    }

    @Override
    public Hash hash(byte[] plainTextPassword, byte[] salt) {
        return this.internalHash(plainTextPassword, salt);
    }

    protected Hash internalHash(byte[] plainTextPassword, byte[] salt) {
        byte[] output;
        if (this.parallelism == 1) {
            byte[] parallelSalt = Utils.append(salt, Utils.longToLittleEndian(1L));
            MessageDigest messageDigest = this.getMessageDigest();
            output = this.balloon(messageDigest, plainTextPassword, parallelSalt);
            output = this.hashFunc(messageDigest, plainTextPassword, salt, output);
        } else if (this.parallelism > 1) {
            ArrayList<Future<byte[]>> futures = new ArrayList<Future<byte[]>>();
            for (int i = 0; i < this.parallelism; ++i) {
                byte[] parallelSalt = Utils.append(salt, Utils.longToLittleEndian(i + 1));
                Future<byte[]> future = this.service.submit(() -> this.balloon(this.getMessageDigest(), plainTextPassword, parallelSalt));
                futures.add(future);
            }
            MessageDigest messageDigest = this.getMessageDigest();
            output = new byte[messageDigest.getDigestLength()];
            try {
                output = (byte[])((Future)futures.get(0)).get();
                for (int f = 1; f < futures.size(); ++f) {
                    byte[] tmp = (byte[])((Future)futures.get(f)).get();
                    for (int i = 0; i < output.length; ++i) {
                        int n = i;
                        output[n] = (byte)(output[n] ^ tmp[i]);
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
            }
            output = this.hashFunc(messageDigest, plainTextPassword, salt, output);
        } else {
            output = this.balloon(this.getMessageDigest(), plainTextPassword, salt);
        }
        return new Hash((HashingFunction)this, Utils.toHex(output), output, salt);
    }

    protected MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new UnsupportedOperationException("`" + this.algorithm + "` is not supported by your system.", nsae);
        }
    }

    private byte[] balloon(MessageDigest messageDigest, byte[] plainTextPassword, byte[] salt) {
        ArrayList<byte[]> buffer = new ArrayList<byte[]>();
        buffer.add(this.hashFunc(messageDigest, 0, plainTextPassword, salt));
        int cnt = 1;
        cnt = this.expand(messageDigest, buffer, cnt);
        this.mix(messageDigest, buffer, cnt, salt);
        return this.extract(buffer);
    }

    private int expand(MessageDigest messageDigest, List<byte[]> buffer, int cnt) {
        int newCnt = cnt;
        for (int i = 1; i < this.spaceCost; ++i) {
            buffer.add(this.hashFunc(messageDigest, newCnt, buffer.get(i - 1)));
            ++newCnt;
        }
        return newCnt;
    }

    private void mix(MessageDigest messageDigest, List<byte[]> buffer, int cnt, byte[] salt) {
        int newCnt = cnt;
        for (int t = 0; t < this.timeCost; ++t) {
            for (int s = 0; s < this.spaceCost; ++s) {
                buffer.set(s, this.hashFunc(messageDigest, newCnt, this.get(buffer, s - 1), this.get(buffer, s)));
                ++newCnt;
                for (int d = 0; d < this.delta; ++d) {
                    byte[] indexBlock = this.hashFunc(messageDigest, t, s, d);
                    int other = Utils.bytesToInt(this.hashFunc(messageDigest, newCnt, salt, indexBlock)).mod(BigInteger.valueOf(this.spaceCost)).intValue();
                    buffer.set(s, this.hashFunc(messageDigest, ++newCnt, buffer.get(s), this.get(buffer, other)));
                    ++newCnt;
                }
            }
        }
    }

    private byte[] extract(List<byte[]> buffer) {
        return buffer.get(buffer.size() - 1);
    }

    private byte[] get(List<byte[]> buffer, int position) {
        if (position < 0) {
            return buffer.get(buffer.size() + position);
        }
        return buffer.get(position);
    }

    private byte[] hashFunc(MessageDigest md, Object ... args) {
        byte[] t = new byte[]{};
        for (Object arg : args) {
            if (arg instanceof Integer) {
                t = Utils.append(t, Utils.intToLittleEndianBytes((Integer)arg, 8));
                continue;
            }
            if (arg instanceof CharSequence) {
                t = Utils.append(t, Utils.fromCharSequenceToBytes((CharSequence)arg));
                continue;
            }
            if (!(arg instanceof byte[])) continue;
            t = Utils.append(t, (byte[])arg);
        }
        return md.digest(t);
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed) {
        return this.check(plainTextPassword, hashed, null);
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed, String salt) {
        Hash hash = this.internalHash(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(salt));
        return BalloonHashingFunction.slowEquals(hash.getResult(), hashed);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed) {
        return this.check(plainTextPassword, new byte[0], hashed, null);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed, byte[] salt) {
        Hash hash = this.internalHash(plainTextPassword, salt);
        return BalloonHashingFunction.slowEquals(hash.getResultAsBytes(), hashed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BalloonHashingFunction)) {
            return false;
        }
        BalloonHashingFunction other = (BalloonHashingFunction)o;
        return this.algorithm.equals(other.algorithm) && this.spaceCost == other.spaceCost && this.timeCost == other.timeCost && this.parallelism == other.parallelism && this.delta == other.delta;
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.spaceCost, this.timeCost, this.parallelism, this.delta);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + BalloonHashingFunction.toString(this.algorithm, this.spaceCost, this.timeCost, this.parallelism, this.delta) + ']';
    }
}

