/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.control.RequestControl;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.jndi.JndiProvider;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionFactory
implements ConnectionFactory {
    public static final String PROVIDER = "org.ldaptive.provider";
    protected static final Provider<?> DEFAULT_PROVIDER = DefaultConnectionFactory.getDefaultProvider();
    private Provider<?> provider = DEFAULT_PROVIDER.newInstance();
    private ConnectionConfig config;

    public DefaultConnectionFactory() {
    }

    public DefaultConnectionFactory(String ldapUrl) {
        this.setConnectionConfig(new ConnectionConfig(ldapUrl));
    }

    public DefaultConnectionFactory(ConnectionConfig cc) {
        this.setConnectionConfig(cc);
    }

    public DefaultConnectionFactory(ConnectionConfig cc, Provider<?> p) {
        this.setConnectionConfig(cc);
        this.setProvider(p);
    }

    public ConnectionConfig getConnectionConfig() {
        return this.config;
    }

    public void setConnectionConfig(ConnectionConfig cc) {
        this.config = cc;
        this.config.makeImmutable();
    }

    public Provider<?> getProvider() {
        return this.provider;
    }

    public void setProvider(Provider<?> p) {
        this.provider = p;
    }

    @Override
    public Connection getConnection() {
        return new DefaultConnection(this.config, this.provider.getConnectionFactory(this.config));
    }

    public static Connection getConnection(String ldapUrl) {
        Provider<?> p = DEFAULT_PROVIDER.newInstance();
        ConnectionConfig cc = new ConnectionConfig(ldapUrl);
        cc.makeImmutable();
        return new DefaultConnection(cc, p.getConnectionFactory(cc));
    }

    public static Connection getConnection(ConnectionConfig cc) {
        Provider<?> p = DEFAULT_PROVIDER.newInstance();
        cc.makeImmutable();
        return new DefaultConnection(cc, p.getConnectionFactory(cc));
    }

    public static Provider<?> getDefaultProvider() {
        Provider<JndiProviderConfig> p;
        String providerClass = System.getProperty(PROVIDER);
        if (providerClass != null) {
            Logger l = LoggerFactory.getLogger(DefaultConnectionFactory.class);
            try {
                l.info("Setting ldap provider to {}", (Object)providerClass);
                p = (Provider)Class.forName(providerClass).newInstance();
            }
            catch (Exception e) {
                l.error("Error instantiating {}", (Object)providerClass, (Object)e);
                throw new IllegalStateException(e);
            }
        } else {
            p = new JndiProvider();
        }
        return p;
    }

    public String toString() {
        return String.format("[%s@%d::provider=%s, config=%s]", this.getClass().getName(), this.hashCode(), this.provider, this.config);
    }

    protected static class DefaultConnection
    implements Connection {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final ConnectionConfig config;
        private final ProviderConnectionFactory<?> providerConnectionFactory;
        private ProviderConnection providerConnection;

        public DefaultConnection(ConnectionConfig cc, ProviderConnectionFactory<?> cf) {
            this.config = cc;
            this.providerConnectionFactory = cf;
        }

        @Override
        public ConnectionConfig getConnectionConfig() {
            return this.config;
        }

        @Override
        public ProviderConnection getProviderConnection() {
            if (!this.isOpen()) {
                throw new IllegalStateException("Connection is not open");
            }
            return this.providerConnection;
        }

        @Override
        public synchronized Response<Void> open() throws LdapException {
            if (this.isOpen()) {
                throw new IllegalStateException("Connection already open");
            }
            this.providerConnection = this.providerConnectionFactory.create();
            if (this.config.getConnectionInitializer() != null) {
                return this.config.getConnectionInitializer().initialize(this);
            }
            return new Response<Object>(null, null);
        }

        @Override
        public synchronized Response<Void> open(BindRequest request) throws LdapException {
            if (this.isOpen()) {
                throw new IllegalStateException("Connection already open");
            }
            this.providerConnection = this.providerConnectionFactory.create();
            return this.providerConnection.bind(request);
        }

        @Override
        public boolean isOpen() {
            return this.providerConnection != null;
        }

        @Override
        public synchronized void close() {
            try {
                if (this.isOpen()) {
                    this.providerConnection.close(null);
                }
            }
            catch (LdapException e) {
                this.logger.warn("Error closing connection with the LDAP", (Throwable)e);
            }
            finally {
                this.providerConnection = null;
            }
        }

        @Override
        public synchronized void close(RequestControl[] controls) {
            try {
                if (this.isOpen()) {
                    this.providerConnection.close(controls);
                }
            }
            catch (LdapException e) {
                this.logger.warn("Error closing connection with the LDAP", (Throwable)e);
            }
            finally {
                this.providerConnection = null;
            }
        }

        @Override
        public synchronized Response<Void> reopen() throws LdapException {
            try {
                if (this.providerConnection != null) {
                    this.providerConnection.close(null);
                }
            }
            catch (LdapException e) {
                this.logger.warn("Error closing connection with the LDAP", (Throwable)e);
            }
            finally {
                this.providerConnection = null;
            }
            this.providerConnection = this.providerConnectionFactory.create();
            if (this.config.getConnectionInitializer() != null) {
                return this.config.getConnectionInitializer().initialize(this);
            }
            return new Response<Object>(null, null);
        }

        @Override
        public synchronized Response<Void> reopen(BindRequest request) throws LdapException {
            try {
                if (this.providerConnection != null) {
                    this.providerConnection.close(null);
                }
            }
            catch (LdapException e) {
                this.logger.warn("Error closing connection with the LDAP", (Throwable)e);
            }
            finally {
                this.providerConnection = null;
            }
            this.providerConnection = this.providerConnectionFactory.create();
            return this.providerConnection.bind(request);
        }

        public String toString() {
            return String.format("[%s@%d::config=%s, providerConnectionFactory=%s, providerConnection=%s]", this.getClass().getName(), this.hashCode(), this.config, this.providerConnectionFactory, this.providerConnection);
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

