/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.google.common.base.Strings;
import java.io.Serializable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.user.User;

public class HeaderHelper {
    public static boolean isInterClusterRequest(ThreadContext context) {
        return context.getTransient("_opendistro_security_ssl_transport_intercluster_request") == Boolean.TRUE;
    }

    public static boolean isDirectRequest(ThreadContext context) {
        return "direct".equals(context.getTransient("_opendistro_security_channel_type")) || context.getTransient("_opendistro_security_channel_type") == null;
    }

    public static boolean isExtensionRequest(ThreadContext context) {
        return context.getTransient("_opendistro_security_ssl_transport_extension_request") == Boolean.TRUE;
    }

    public static boolean isInternalOrPluginRequest(ThreadContext threadContext) {
        User user = (User)threadContext.getTransient("_opendistro_security_user");
        return user == null || user.isPluginUser();
    }

    public static String getSafeFromHeader(ThreadContext context, String headerName) {
        if (context == null || headerName == null || headerName.isEmpty()) {
            return null;
        }
        if (HeaderHelper.isInterClusterRequest(context) || HeaderHelper.isTrustedClusterRequest(context) || HeaderHelper.isDirectRequest(context)) {
            return context.getHeader(headerName);
        }
        return null;
    }

    public static Serializable deserializeSafeFromHeader(ThreadContext context, String headerName) {
        String objectAsBase64 = HeaderHelper.getSafeFromHeader(context, headerName);
        if (!Strings.isNullOrEmpty((String)objectAsBase64)) {
            return Base64Helper.deserializeObject(objectAsBase64);
        }
        return null;
    }

    public static boolean isTrustedClusterRequest(ThreadContext context) {
        return context.getTransient("_opendistro_security_ssl_transport_trustedcluster_request") == Boolean.TRUE;
    }
}

