/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.ManageNameIDRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDMappingRequest;
import org.opensaml.saml.saml2.core.NameIDMappingResponse;
import org.opensaml.saml.saml2.core.NewEncryptedID;
import org.opensaml.saml.saml2.core.NewID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectQuery;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.saml.saml2.profile.impl.AbstractEncryptAction;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class EncryptNameIDs
extends AbstractEncryptAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EncryptNameIDs.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLObject> messageLookupStrategy = new MessageLookup<SAMLObject>(SAMLObject.class).compose(new OutboundMessageContextLookup());
    @Nonnull
    private Set<String> excludedFormats = CollectionSupport.singleton("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
    @NonnullBeforeExec
    private SAMLObject message;

    public void setMessageLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.checkSetterPreconditions();
        this.messageLookupStrategy = Constraint.isNotNull(strategy, "Message lookup strategy cannot be null");
    }

    public void setExcludedFormats(@Nonnull Collection<String> formats) {
        this.excludedFormats = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(formats));
    }

    @Override
    @Nullable
    protected EncryptionParameters getApplicableParameters(@Nullable EncryptionContext ctx) {
        if (ctx != null) {
            return ctx.getIdentifierEncryptionParameters();
        }
        return null;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.message = this.messageLookupStrategy.apply(profileRequestContext);
        if (this.message != null && this.message instanceof ArtifactResponse) {
            this.message = ((ArtifactResponse)this.message).getMessage();
        }
        if (this.message == null) {
            this.log.debug("{} Message was not present, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        block12: {
            try {
                Object object = this.message;
                if (object instanceof AuthnRequest) {
                    AuthnRequest m = (AuthnRequest)object;
                    this.processSubject(m.getSubject());
                    break block12;
                }
                object = this.message;
                if (object instanceof SubjectQuery) {
                    SubjectQuery m = (SubjectQuery)object;
                    this.processSubject(m.getSubject());
                    break block12;
                }
                object = this.message;
                if (object instanceof Response) {
                    Response m = (Response)object;
                    for (Assertion a : m.getAssertions()) {
                        assert (a != null);
                        this.processAssertion(a);
                    }
                    break block12;
                }
                object = this.message;
                if (object instanceof LogoutRequest) {
                    LogoutRequest m = (LogoutRequest)object;
                    this.processLogoutRequest(m);
                    break block12;
                }
                object = this.message;
                if (object instanceof ManageNameIDRequest) {
                    ManageNameIDRequest m = (ManageNameIDRequest)object;
                    this.processManageNameIDRequest(m);
                    break block12;
                }
                object = this.message;
                if (object instanceof NameIDMappingRequest) {
                    NameIDMappingRequest m = (NameIDMappingRequest)object;
                    this.processNameIDMappingRequest(m);
                    break block12;
                }
                object = this.message;
                if (object instanceof NameIDMappingResponse) {
                    NameIDMappingResponse m = (NameIDMappingResponse)object;
                    this.processNameIDMappingResponse(m);
                    break block12;
                }
                object = this.message;
                if (object instanceof Assertion) {
                    Assertion m = (Assertion)object;
                    this.processAssertion(m);
                    break block12;
                }
                this.log.debug("{} Message was of unrecognized type {}, nothing to do", (Object)this.getLogPrefix(), (Object)this.message.getClass().getName());
                return;
            }
            catch (EncryptionException e) {
                this.log.warn("{} Error encrypting NameID", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent(profileRequestContext, "UnableToEncrypt");
            }
        }
    }

    private boolean shouldEncrypt(@Nonnull NameID name) {
        String format = name.getFormat();
        if (format == null) {
            format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        if (!this.excludedFormats.contains(format)) {
            if (this.log.isDebugEnabled()) {
                try {
                    Element dom = XMLObjectSupport.marshall(name);
                    this.log.debug("{} NameID before encryption:\n{}", (Object)this.getLogPrefix(), (Object)SerializeSupport.prettyPrintXML(dom));
                }
                catch (MarshallingException e) {
                    this.log.error("{} Unable to marshall NameID for logging purposes", (Object)this.getLogPrefix(), (Object)e);
                }
            }
            return true;
        }
        return false;
    }

    private void processSubject(@Nullable Subject subject) throws EncryptionException {
        if (subject != null) {
            NameID nameID = subject.getNameID();
            if (nameID != null && this.shouldEncrypt(nameID)) {
                this.log.debug("{} Encrypt NameID in Subject", (Object)this.getLogPrefix());
                EncryptedID encrypted = this.getEncrypter().encrypt(nameID);
                subject.setEncryptedID(encrypted);
                subject.setNameID(null);
            }
            for (SubjectConfirmation sc : subject.getSubjectConfirmations()) {
                nameID = sc.getNameID();
                if (nameID == null || !this.shouldEncrypt(nameID)) continue;
                this.log.debug("{} Encrypt NameID in SubjectConfirmation", (Object)this.getLogPrefix());
                EncryptedID encrypted = this.getEncrypter().encrypt(nameID);
                sc.setEncryptedID(encrypted);
                sc.setNameID(null);
            }
        }
    }

    private void processLogoutRequest(@Nonnull LogoutRequest request) throws EncryptionException {
        NameID nameID = request.getNameID();
        if (nameID != null && this.shouldEncrypt(nameID)) {
            this.log.debug("{} Encrypting NameID in LogoutRequest", (Object)this.getLogPrefix());
            EncryptedID encrypted = this.getEncrypter().encrypt(nameID);
            request.setEncryptedID(encrypted);
            request.setNameID(null);
        }
    }

    private void processManageNameIDRequest(@Nonnull ManageNameIDRequest request) throws EncryptionException {
        NewID newID;
        NameID nameID = request.getNameID();
        if (nameID != null && this.shouldEncrypt(nameID)) {
            this.log.debug("{} Encrypting NameID in ManageNameIDRequest", (Object)this.getLogPrefix());
            EncryptedID encrypted = this.getEncrypter().encrypt(nameID);
            request.setEncryptedID(encrypted);
            request.setNameID(null);
        }
        if ((newID = request.getNewID()) != null && request.getNewID() != null) {
            this.log.debug("{} Encrypting NewID in ManageNameIDRequest", (Object)this.getLogPrefix());
            NewEncryptedID encrypted = this.getEncrypter().encrypt(newID);
            request.setNewEncryptedID(encrypted);
            request.setNewID(null);
        }
    }

    private void processNameIDMappingRequest(@Nonnull NameIDMappingRequest request) throws EncryptionException {
        NameID nameID = request.getNameID();
        if (nameID != null && this.shouldEncrypt(nameID)) {
            this.log.debug("{} Encrypting NameID in NameIDMappingRequest", (Object)this.getLogPrefix());
            EncryptedID encrypted = this.getEncrypter().encrypt(nameID);
            request.setEncryptedID(encrypted);
            request.setNameID(null);
        }
    }

    private void processNameIDMappingResponse(@Nonnull NameIDMappingResponse response) throws EncryptionException {
        NameID nameID = response.getNameID();
        if (nameID != null && this.shouldEncrypt(nameID)) {
            this.log.debug("{} Encrypting NameID in NameIDMappingResponse", (Object)this.getLogPrefix());
            EncryptedID encrypted = this.getEncrypter().encrypt(nameID);
            response.setEncryptedID(encrypted);
            response.setNameID(null);
        }
    }

    private void processAssertion(@Nonnull Assertion assertion) throws EncryptionException {
        this.processSubject(assertion.getSubject());
        Conditions conditions = assertion.getConditions();
        if (conditions != null) {
            for (Condition c : conditions.getConditions()) {
                if (!(c instanceof DelegationRestrictionType)) continue;
                for (Delegate d : ((DelegationRestrictionType)c).getDelegates()) {
                    NameID nameID = d.getNameID();
                    if (nameID == null || !this.shouldEncrypt(nameID)) continue;
                    this.log.debug("{} Encrypting NameID in Delegate", (Object)this.getLogPrefix());
                    EncryptedID encrypted = this.getEncrypter().encrypt(nameID);
                    d.setEncryptedID(encrypted);
                    d.setNameID(null);
                }
            }
        }
    }
}

