/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.criterion;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class BestMatchLocationCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private final String location;

    public BestMatchLocationCriterion(@Nonnull @NotEmpty String locationUri) {
        this.location = Constraint.isNotNull(StringSupport.trimOrNull(locationUri), "Location cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getLocation() {
        return this.location;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BestMatchLocation [location=");
        builder.append(this.location);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BestMatchLocationCriterion) {
            BestMatchLocationCriterion other = (BestMatchLocationCriterion)obj;
            return this.location.equals(other.location);
        }
        return false;
    }
}

