/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.util.Configuration;
import com.azure.core.util.HttpClientOptions;
import com.azure.core.util.logging.ClientLogger;
import reactor.netty.resources.ConnectionProvider;

public final class NettyAsyncHttpClientProvider
implements HttpClientProvider {
    private static final boolean AZURE_ENABLE_HTTP_CLIENT_SHARING = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    private final boolean enableHttpClientSharing;
    private static final int DEFAULT_MAX_CONNECTIONS = 500;
    private static final ClientLogger LOGGER = new ClientLogger(NettyAsyncHttpClientProvider.class);

    public NettyAsyncHttpClientProvider() {
        this.enableHttpClientSharing = AZURE_ENABLE_HTTP_CLIENT_SHARING;
    }

    NettyAsyncHttpClientProvider(Configuration configuration) {
        this.enableHttpClientSharing = (Boolean)configuration.get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    }

    public HttpClient createInstance() {
        if (this.enableHttpClientSharing) {
            return GlobalNettyHttpClient.HTTP_CLIENT.getHttpClient();
        }
        return new NettyAsyncHttpClientBuilder().build();
    }

    public HttpClient createInstance(HttpClientOptions clientOptions) {
        if (clientOptions == null) {
            return this.createInstance();
        }
        NettyAsyncHttpClientBuilder builder = new NettyAsyncHttpClientBuilder();
        builder = builder.proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).connectTimeout(clientOptions.getConnectTimeout()).writeTimeout(clientOptions.getWriteTimeout()).responseTimeout(clientOptions.getResponseTimeout()).readTimeout(clientOptions.getReadTimeout());
        ConnectionProvider.Builder connectionProviderBuilder = ConnectionProvider.builder((String)"azure-sdk");
        connectionProviderBuilder.maxIdleTime(clientOptions.getConnectionIdleTimeout());
        Integer maximumConnectionPoolSize = clientOptions.getMaximumConnectionPoolSize();
        if (maximumConnectionPoolSize != null && maximumConnectionPoolSize > 0) {
            LOGGER.verbose("Setting Reactor Netty ConnectionProvider's maximum connections to " + maximumConnectionPoolSize + ".");
            connectionProviderBuilder.maxConnections(maximumConnectionPoolSize.intValue());
        } else {
            connectionProviderBuilder.maxConnections(500);
        }
        builder = builder.connectionProviderInternal(connectionProviderBuilder.build());
        return builder.build();
    }

    private static enum GlobalNettyHttpClient {
        HTTP_CLIENT(new NettyAsyncHttpClientBuilder().build());

        private final HttpClient httpClient;

        private GlobalNettyHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        private HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

